/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.item.builder;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.invui.item.builder.AbstractItemBuilder;

public final class PotionBuilder
extends AbstractItemBuilder<PotionBuilder> {
    private List<PotionEffect> effects = new ArrayList<PotionEffect>();
    private org.bukkit.Color color;
    private PotionData basePotionData;

    public PotionBuilder(@NotNull PotionType type) {
        super(type.getMaterial());
    }

    public PotionBuilder(@NotNull ItemStack base) {
        super(base);
    }

    @Contract(value="_ -> this")
    @NotNull
    public PotionBuilder setColor(@NotNull org.bukkit.Color color) {
        this.color = color;
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public PotionBuilder setColor(@NotNull Color color) {
        this.color = org.bukkit.Color.fromRGB((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public PotionBuilder setBasePotionData(@NotNull PotionData basePotionData) {
        this.basePotionData = basePotionData;
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public PotionBuilder addEffect(@NotNull PotionEffect effect) {
        this.effects.add(effect);
        return this;
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public ItemStack get(@Nullable String lang) {
        ItemStack item = super.get(lang);
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        meta.clearCustomEffects();
        if (this.color != null) {
            meta.setColor(this.color);
        }
        if (this.basePotionData != null) {
            meta.setBasePotionData(this.basePotionData);
        }
        this.effects.forEach(effect -> meta.addCustomEffect(effect, true));
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    @Override
    @NotNull
    public PotionBuilder clone() {
        PotionBuilder builder = (PotionBuilder)super.clone();
        builder.effects = new ArrayList<PotionEffect>(this.effects);
        return builder;
    }

    public static enum PotionType {
        NORMAL(Material.POTION),
        SPLASH(Material.SPLASH_POTION),
        LINGERING(Material.LINGERING_POTION);

        @NotNull
        private final Material material;

        private PotionType(Material material) {
            this.material = material;
        }

        @NotNull
        public Material getMaterial() {
            return this.material;
        }
    }
}

