/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.util;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.invui.util.Point2D;

public class SlotUtils {
    @NotNull
    public static Set<Integer> getSlotsRow(int row, int width) {
        LinkedHashSet<Integer> slots = new LinkedHashSet<Integer>();
        for (int x = 0; x < width; ++x) {
            slots.add(SlotUtils.convertToIndex(x, row, width));
        }
        return slots;
    }

    @NotNull
    public static Set<Integer> getSlotsColumn(int column, int width, int height) {
        LinkedHashSet<Integer> slots = new LinkedHashSet<Integer>();
        for (int y = 0; y < height; ++y) {
            slots.add(SlotUtils.convertToIndex(column, y, width));
        }
        return slots;
    }

    @NotNull
    public static Set<Integer> getSlotsBorders(int width, int height) {
        LinkedHashSet<Integer> slots = new LinkedHashSet<Integer>();
        if (height > 0) {
            slots.addAll(SlotUtils.getSlotsRow(0, width));
        }
        if (height - 1 > 0) {
            slots.addAll(SlotUtils.getSlotsRow(height - 1, width));
        }
        if (width > 0) {
            slots.addAll(SlotUtils.getSlotsColumn(0, width, height));
        }
        if (width - 1 > 0) {
            slots.addAll(SlotUtils.getSlotsColumn(width - 1, width, height));
        }
        return slots;
    }

    @NotNull
    public static Set<Integer> getSlotsRect(int x, int y, int width, int height, int frameWidth) {
        return SlotUtils.getSlotsRect(Order.HORIZONTAL, x, y, width, height, frameWidth);
    }

    @NotNull
    public static Set<Integer> getSlotsRect(@NotNull Order order, int x, int y, int width, int height, int frameWidth) {
        LinkedHashSet<Integer> slots = new LinkedHashSet<Integer>();
        switch (order.ordinal()) {
            case 0: {
                for (int y1 = y; y1 < height + y; ++y1) {
                    for (int x1 = x; x1 < width + x; ++x1) {
                        slots.add(SlotUtils.convertToIndex(x1, y1, frameWidth));
                    }
                }
                break;
            }
            case 1: {
                for (int x1 = x; x1 < width + x; ++x1) {
                    for (int y1 = y; y1 < height + y; ++y1) {
                        slots.add(SlotUtils.convertToIndex(x1, y1, frameWidth));
                    }
                }
                break;
            }
        }
        return slots;
    }

    public static int convertToIndex(@NotNull Point2D point, int width) {
        return SlotUtils.convertToIndex(point.getX(), point.getY(), width);
    }

    public static int convertToIndex(int x, int y, int width) {
        return y * width + x;
    }

    @NotNull
    public static Point2D convertFromIndex(int index, int width) {
        return new Point2D(index % width, index / width);
    }

    public static int translatePlayerInvToGui(int slot) {
        if (slot > 8) {
            return slot - 9;
        }
        return slot + 27;
    }

    public static int translateGuiToPlayerInv(int slot) {
        if (slot > 26) {
            return slot - 27;
        }
        return slot + 9;
    }

    public static int getLongestLineLength(int[] slots, int frameWidth) {
        int longestLength = 0;
        int currentLength = 1;
        Point2D previous = null;
        for (Point2D point : Arrays.stream(slots).mapToObj(index -> SlotUtils.convertFromIndex(index, frameWidth)).collect(Collectors.toList())) {
            if (previous != null) {
                currentLength = SlotUtils.isNeighbor(previous, point) ? ++currentLength : 1;
            }
            previous = point;
            longestLength = Math.max(longestLength, currentLength);
        }
        return longestLength;
    }

    public static boolean isNeighbor(@NotNull Point2D point1, @NotNull Point2D point2) {
        return Math.abs(point1.getX() - point2.getX()) + Math.abs(point1.getY() - point2.getY()) == 1;
    }

    public static enum Order {
        HORIZONTAL,
        VERTICAL;

    }
}

