/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.window;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import xyz.xenondevs.inventoryaccess.component.ComponentWrapper;
import xyz.xenondevs.invui.gui.AbstractGui;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.gui.SlotElement;
import xyz.xenondevs.invui.inventory.ReferencingInventory;
import xyz.xenondevs.invui.util.Pair;
import xyz.xenondevs.invui.util.SlotUtils;
import xyz.xenondevs.invui.window.AbstractDoubleWindow;

public abstract class AbstractMergedWindow
extends AbstractDoubleWindow {
    private final AbstractGui gui;

    public AbstractMergedWindow(Player player, ComponentWrapper title, AbstractGui gui, Inventory upperInventory, boolean closeable) {
        super(player, title, gui.getSize(), upperInventory, closeable);
        this.gui = gui;
    }

    @Override
    public void handleSlotElementUpdate(Gui child, int slotIndex) {
        this.redrawItem(slotIndex, this.gui.getSlotElement(slotIndex), true);
    }

    @Override
    protected SlotElement getSlotElement(int index) {
        return this.gui.getSlotElement(index);
    }

    @Override
    protected Pair<AbstractGui, Integer> getWhereClicked(InventoryClickEvent event) {
        Inventory clicked = event.getClickedInventory();
        int slot = event.getSlot();
        int clickedIndex = clicked == this.getUpperInventory() ? slot : this.getUpperInventory().getSize() + SlotUtils.translatePlayerInvToGui(slot);
        return new Pair<AbstractGui, Integer>(this.gui, clickedIndex);
    }

    @Override
    protected Pair<AbstractGui, Integer> getGuiAt(int index) {
        return index < this.gui.getSize() ? new Pair<AbstractGui, Integer>(this.gui, index) : null;
    }

    @Override
    public AbstractGui[] getGuis() {
        return new AbstractGui[]{this.gui};
    }

    @Override
    protected List<xyz.xenondevs.invui.inventory.Inventory> getContentInventories() {
        ArrayList<xyz.xenondevs.invui.inventory.Inventory> inventories = new ArrayList<xyz.xenondevs.invui.inventory.Inventory>(this.gui.getAllInventories(new xyz.xenondevs.invui.inventory.Inventory[0]));
        inventories.add(ReferencingInventory.fromStorageContents((Inventory)this.getViewer().getInventory()));
        return inventories;
    }
}

