/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.window;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.inventoryaccess.component.ComponentWrapper;
import xyz.xenondevs.invui.gui.AbstractGui;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.gui.SlotElement;
import xyz.xenondevs.invui.util.Pair;
import xyz.xenondevs.invui.util.SlotUtils;
import xyz.xenondevs.invui.window.AbstractDoubleWindow;
import xyz.xenondevs.invui.window.AbstractWindow;
import xyz.xenondevs.invui.window.Window;

public abstract class AbstractSplitWindow
extends AbstractDoubleWindow {
    private final AbstractGui upperGui;
    private final AbstractGui lowerGui;

    public AbstractSplitWindow(Player player, ComponentWrapper title, AbstractGui upperGui, AbstractGui lowerGui, Inventory upperInventory, boolean closeable) {
        super(player, title, upperGui.getSize() + lowerGui.getSize(), upperInventory, closeable);
        this.upperGui = upperGui;
        this.lowerGui = lowerGui;
    }

    @Override
    public void handleSlotElementUpdate(Gui child, int slotIndex) {
        this.redrawItem(child == this.upperGui ? slotIndex : this.upperGui.getSize() + slotIndex, child.getSlotElement(slotIndex), true);
    }

    @Override
    public SlotElement getSlotElement(int index) {
        if (index >= this.upperGui.getSize()) {
            return this.lowerGui.getSlotElement(index - this.upperGui.getSize());
        }
        return this.upperGui.getSlotElement(index);
    }

    @Override
    protected Pair<AbstractGui, Integer> getWhereClicked(InventoryClickEvent event) {
        Inventory clicked = event.getClickedInventory();
        if (clicked == this.getUpperInventory()) {
            return new Pair<AbstractGui, Integer>(this.upperGui, event.getSlot());
        }
        int index = SlotUtils.translatePlayerInvToGui(event.getSlot());
        return new Pair<AbstractGui, Integer>(this.lowerGui, index);
    }

    @Override
    protected Pair<AbstractGui, Integer> getGuiAt(int index) {
        if (index < this.upperGui.getSize()) {
            return new Pair<AbstractGui, Integer>(this.upperGui, index);
        }
        if (index < this.upperGui.getSize() + this.lowerGui.getSize()) {
            return new Pair<AbstractGui, Integer>(this.lowerGui, index - this.upperGui.getSize());
        }
        return null;
    }

    @Override
    public AbstractGui[] getGuis() {
        return new AbstractGui[]{this.upperGui, this.lowerGui};
    }

    @Override
    protected List<xyz.xenondevs.invui.inventory.Inventory> getContentInventories() {
        ArrayList<xyz.xenondevs.invui.inventory.Inventory> inventories = new ArrayList<xyz.xenondevs.invui.inventory.Inventory>();
        inventories.addAll(this.upperGui.getAllInventories(new xyz.xenondevs.invui.inventory.Inventory[0]));
        inventories.addAll(this.lowerGui.getAllInventories(new xyz.xenondevs.invui.inventory.Inventory[0]));
        return inventories;
    }

    public static abstract class AbstractBuilder<W extends Window, S extends Window.Builder.Double<W, S>>
    extends AbstractWindow.AbstractBuilder<W, S>
    implements Window.Builder.Double<W, S> {
        protected Supplier<Gui> upperGuiSupplier;
        protected Supplier<Gui> lowerGuiSupplier;

        @Override
        @NotNull
        public S setUpperGui(@NotNull Supplier<Gui> guiSupplier) {
            this.upperGuiSupplier = guiSupplier;
            return (S)this;
        }

        @Override
        @NotNull
        public S setUpperGui(@NotNull Gui gui) {
            this.upperGuiSupplier = () -> gui;
            return (S)this;
        }

        @Override
        @NotNull
        public S setUpperGui(@NotNull Gui.Builder<?, ?> builder) {
            this.upperGuiSupplier = builder::build;
            return (S)this;
        }

        @Override
        @NotNull
        public S setLowerGui(@NotNull Supplier<Gui> guiSupplier) {
            this.lowerGuiSupplier = guiSupplier;
            return (S)this;
        }

        @Override
        @NotNull
        public S setLowerGui(@NotNull Gui gui) {
            this.lowerGuiSupplier = () -> gui;
            return (S)this;
        }

        @Override
        @NotNull
        public S setLowerGui(@NotNull Gui.Builder<?, ?> builder) {
            this.lowerGuiSupplier = builder::build;
            return (S)this;
        }
    }
}

