/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.window;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.inventoryaccess.InventoryAccess;
import xyz.xenondevs.inventoryaccess.component.BungeeComponentWrapper;
import xyz.xenondevs.inventoryaccess.component.ComponentWrapper;
import xyz.xenondevs.inventoryaccess.component.i18n.Languages;
import xyz.xenondevs.invui.InvUI;
import xyz.xenondevs.invui.gui.AbstractGui;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.gui.GuiParent;
import xyz.xenondevs.invui.gui.SlotElement;
import xyz.xenondevs.invui.inventory.CompositeInventory;
import xyz.xenondevs.invui.inventory.Inventory;
import xyz.xenondevs.invui.inventory.event.PlayerUpdateReason;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.invui.item.ItemProvider;
import xyz.xenondevs.invui.util.ArrayUtils;
import xyz.xenondevs.invui.util.Pair;
import xyz.xenondevs.invui.window.Window;
import xyz.xenondevs.invui.window.WindowManager;

public abstract class AbstractWindow
implements Window,
GuiParent {
    private static final NamespacedKey SLOT_KEY = new NamespacedKey(InvUI.getInstance().getPlugin(), "slot");
    private final Player viewer;
    private final UUID viewerUUID;
    private final SlotElement[] elementsDisplayed;
    private List<Runnable> openHandlers;
    private List<Runnable> closeHandlers;
    private List<Consumer<InventoryClickEvent>> outsideClickHandlers;
    private ComponentWrapper title;
    private boolean closeable;
    private boolean currentlyOpen;
    private boolean hasHandledClose;

    public AbstractWindow(Player viewer, ComponentWrapper title, int size, boolean closeable) {
        this.viewer = viewer;
        this.viewerUUID = viewer.getUniqueId();
        this.title = title;
        this.closeable = closeable;
        this.elementsDisplayed = new SlotElement[size];
    }

    protected void redrawItem(int index) {
        this.redrawItem(index, this.getSlotElement(index), false);
    }

    protected void redrawItem(int index, SlotElement element, boolean setItem) {
        ItemStack itemStack;
        ItemProvider background;
        if (element == null || element instanceof SlotElement.InventorySlotElement && element.getItemStack(this.viewer, this.getLang()) == null) {
            background = this.getGuiAt(index).getFirst().getBackground();
            itemStack = background == null ? null : background.get(this.getLang());
        } else if (element instanceof SlotElement.LinkedSlotElement && element.getHoldingElement() == null) {
            background = null;
            List<Gui> guis = ((SlotElement.LinkedSlotElement)element).getGuiList();
            guis.add(0, this.getGuiAt(index).getFirst());
            for (int i = guis.size() - 1; i >= 0 && (background = guis.get(i).getBackground()) == null; --i) {
            }
            itemStack = background == null ? null : background.get(this.getLang());
        } else {
            SlotElement holdingElement = element.getHoldingElement();
            itemStack = holdingElement.getItemStack(this.viewer, this.getLang());
            if (holdingElement instanceof SlotElement.ItemSlotElement && itemStack.hasItemMeta()) {
                itemStack = itemStack.clone();
                ItemMeta itemMeta = itemStack.getItemMeta();
                itemMeta.getPersistentDataContainer().set(SLOT_KEY, PersistentDataType.BYTE, (Object)((byte)index));
                itemStack.setItemMeta(itemMeta);
            }
        }
        this.setInvItem(index, itemStack);
        if (setItem) {
            SlotElement previousElement = this.elementsDisplayed[index];
            if (previousElement instanceof SlotElement.ItemSlotElement) {
                SlotElement.ItemSlotElement itemSlotElement = (SlotElement.ItemSlotElement)previousElement;
                Item item = itemSlotElement.getItem();
                if (this.getItemSlotElements(item).size() == 1) {
                    item.removeWindow(this);
                }
            } else if (previousElement instanceof SlotElement.InventorySlotElement) {
                SlotElement.InventorySlotElement invSlotElement = (SlotElement.InventorySlotElement)previousElement;
                Inventory inventory = invSlotElement.getInventory();
                if (this.getInvSlotElements(invSlotElement.getInventory()).size() == 1) {
                    inventory.removeWindow(this);
                }
            }
            if (element != null) {
                SlotElement holdingElement = element.getHoldingElement();
                if (holdingElement instanceof SlotElement.ItemSlotElement) {
                    ((SlotElement.ItemSlotElement)holdingElement).getItem().addWindow(this);
                } else if (holdingElement instanceof SlotElement.InventorySlotElement) {
                    ((SlotElement.InventorySlotElement)holdingElement).getInventory().addWindow(this);
                }
                this.elementsDisplayed[index] = holdingElement;
            } else {
                this.elementsDisplayed[index] = null;
            }
        }
    }

    public void handleDragEvent(InventoryDragEvent event) {
        Player player = ((Player)event.getWhoClicked()).getPlayer();
        PlayerUpdateReason updateReason = new PlayerUpdateReason(player, (InventoryEvent)event);
        Map newItems = event.getNewItems();
        int itemsLeft = event.getCursor() == null ? 0 : event.getCursor().getAmount();
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            Pair<AbstractGui, Integer> pair;
            int rawSlot = (Integer)iterator.next();
            ItemStack currentStack = InventoryAccess.getInventoryUtils().getItemStackFromView(event.getView(), rawSlot);
            if (currentStack != null && currentStack.getType() == Material.AIR) {
                currentStack = null;
            }
            if ((pair = this.getGuiAt(rawSlot)) == null || pair.getFirst().handleItemDrag(updateReason, pair.getSecond(), currentStack, (ItemStack)newItems.get(rawSlot))) continue;
            int currentAmount = currentStack == null ? 0 : currentStack.getAmount();
            int newAmount = ((ItemStack)newItems.get(rawSlot)).getAmount();
            itemsLeft += newAmount - currentAmount;
        }
        Bukkit.getScheduler().runTask(InvUI.getInstance().getPlugin(), () -> event.getRawSlots().forEach(rawSlot -> {
            if (this.getGuiAt((int)rawSlot) != null) {
                this.redrawItem((int)rawSlot);
            }
        }));
        ItemStack cursorStack = event.getOldCursor();
        cursorStack.setAmount(itemsLeft);
        event.setCursor(cursorStack);
    }

    public void handleClickEvent(InventoryClickEvent event) {
        if (Arrays.asList(this.getInventories()).contains(event.getClickedInventory())) {
            this.handleClick(event);
        } else if (event.getSlotType() == InventoryType.SlotType.OUTSIDE) {
            if (this.outsideClickHandlers != null) {
                for (Consumer<InventoryClickEvent> handler : this.outsideClickHandlers) {
                    handler.accept(event);
                }
            }
        } else {
            switch (event.getAction()) {
                case MOVE_TO_OTHER_INVENTORY: {
                    this.handleItemShift(event);
                    break;
                }
                case COLLECT_TO_CURSOR: {
                    this.handleCursorCollect(event);
                }
            }
        }
    }

    public void handleCursorCollect(InventoryClickEvent event) {
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack template = event.getCursor();
        List<Inventory> inventories = this.getContentInventories();
        CompositeInventory inventory = new CompositeInventory(inventories);
        PlayerUpdateReason updateReason = new PlayerUpdateReason(player, (InventoryEvent)event);
        int amount = inventory.collectSimilar(updateReason, template);
        template.setAmount(amount);
        event.setCursor(template);
    }

    public void handleItemProviderUpdate(Item item) {
        this.getItemSlotElements(item).forEach((index, slotElement) -> this.redrawItem((int)index, (SlotElement)slotElement, false));
    }

    public void handleInventoryUpdate(Inventory inventory) {
        this.getInvSlotElements(inventory).forEach((index, slotElement) -> this.redrawItem((int)index, (SlotElement)slotElement, false));
    }

    protected Map<Integer, SlotElement> getItemSlotElements(Item item) {
        return ArrayUtils.findAllOccurrences(this.elementsDisplayed, element -> element instanceof SlotElement.ItemSlotElement && ((SlotElement.ItemSlotElement)element).getItem() == item);
    }

    protected Map<Integer, SlotElement> getInvSlotElements(Inventory inventory) {
        return ArrayUtils.findAllOccurrences(this.elementsDisplayed, element -> element instanceof SlotElement.InventorySlotElement && ((SlotElement.InventorySlotElement)element).getInventory() == inventory);
    }

    @Override
    public void open() {
        Player viewer = this.getViewer();
        if (this.currentlyOpen) {
            throw new IllegalStateException("Window is already open");
        }
        AbstractWindow openWindow = (AbstractWindow)WindowManager.getInstance().getOpenWindow(viewer);
        if (openWindow != null) {
            openWindow.handleCloseEvent(true);
        }
        this.currentlyOpen = true;
        this.hasHandledClose = false;
        this.initItems();
        WindowManager.getInstance().addWindow(this);
        for (AbstractGui gui : this.getGuis()) {
            gui.addParent(this);
        }
        this.openInventory(viewer);
    }

    protected void openInventory(@NotNull Player viewer) {
        InventoryAccess.getInventoryUtils().openCustomInventory(viewer, this.getInventories()[0], this.title != null ? this.title.localized(viewer) : null);
    }

    public void handleOpenEvent(InventoryOpenEvent event) {
        if (!event.getPlayer().equals((Object)this.getViewer())) {
            event.setCancelled(true);
        } else {
            this.handleOpened();
            if (this.openHandlers != null) {
                this.openHandlers.forEach(Runnable::run);
            }
        }
    }

    @Override
    public void close() {
        Player viewer = this.getCurrentViewer();
        if (viewer != null) {
            this.handleCloseEvent(true);
            viewer.closeInventory();
        }
    }

    public void handleCloseEvent(boolean forceClose) {
        if (this.hasHandledClose) {
            return;
        }
        if (this.closeable || forceClose) {
            if (!this.currentlyOpen) {
                throw new IllegalStateException("Window is already closed!");
            }
            this.closeable = true;
            this.currentlyOpen = false;
            this.hasHandledClose = true;
            this.remove();
            this.handleClosed();
            if (this.closeHandlers != null) {
                this.closeHandlers.forEach(Runnable::run);
            }
        } else {
            Bukkit.getScheduler().runTaskLater(InvUI.getInstance().getPlugin(), () -> this.openInventory(this.viewer), 0L);
        }
    }

    private void remove() {
        WindowManager.getInstance().removeWindow(this);
        Arrays.stream(this.elementsDisplayed).filter(Objects::nonNull).map(SlotElement::getHoldingElement).forEach(slotElement -> {
            if (slotElement instanceof SlotElement.ItemSlotElement) {
                ((SlotElement.ItemSlotElement)slotElement).getItem().removeWindow(this);
            } else if (slotElement instanceof SlotElement.InventorySlotElement) {
                ((SlotElement.InventorySlotElement)slotElement).getInventory().removeWindow(this);
            }
        });
        for (AbstractGui gui : this.getGuis()) {
            gui.removeParent(this);
        }
    }

    @Override
    public void changeTitle(@NotNull ComponentWrapper title) {
        this.title = title;
        Player currentViewer = this.getCurrentViewer();
        if (currentViewer != null) {
            InventoryAccess.getInventoryUtils().updateOpenInventoryTitle(currentViewer, title.localized(currentViewer));
        }
    }

    @Override
    public void changeTitle(@NotNull BaseComponent[] title) {
        this.changeTitle(new BungeeComponentWrapper(title));
    }

    @Override
    public void changeTitle(@NotNull String title) {
        this.changeTitle(TextComponent.fromLegacyText((String)title));
    }

    @Override
    public void setOpenHandlers(@Nullable List<@NotNull Runnable> openHandlers) {
        this.openHandlers = openHandlers;
    }

    @Override
    public void addOpenHandler(@NotNull Runnable openHandler) {
        if (this.openHandlers == null) {
            this.openHandlers = new ArrayList<Runnable>();
        }
        this.openHandlers.add(openHandler);
    }

    @Override
    public void setCloseHandlers(@Nullable List<@NotNull Runnable> closeHandlers) {
        this.closeHandlers = closeHandlers;
    }

    @Override
    public void addCloseHandler(@NotNull Runnable closeHandler) {
        if (this.closeHandlers == null) {
            this.closeHandlers = new ArrayList<Runnable>();
        }
        this.closeHandlers.add(closeHandler);
    }

    @Override
    public void removeCloseHandler(@NotNull Runnable closeHandler) {
        if (this.closeHandlers != null) {
            this.closeHandlers.remove(closeHandler);
        }
    }

    @Override
    public void setOutsideClickHandlers(@Nullable List<@NotNull Consumer<@NotNull InventoryClickEvent>> outsideClickHandlers) {
        this.outsideClickHandlers = outsideClickHandlers;
    }

    @Override
    public void addOutsideClickHandler(@NotNull @NotNull Consumer<@NotNull InventoryClickEvent> outsideClickHandler) {
        if (this.outsideClickHandlers == null) {
            this.outsideClickHandlers = new ArrayList<Consumer<InventoryClickEvent>>();
        }
        this.outsideClickHandlers.add(outsideClickHandler);
    }

    @Override
    public void removeOutsideClickHandler(@NotNull @NotNull Consumer<@NotNull InventoryClickEvent> outsideClickHandler) {
        if (this.outsideClickHandlers != null) {
            this.outsideClickHandlers.remove(outsideClickHandler);
        }
    }

    @Override
    @Nullable
    public Player getCurrentViewer() {
        List viewers = this.getInventories()[0].getViewers();
        return viewers.isEmpty() ? null : (Player)viewers.get(0);
    }

    @Override
    @NotNull
    public Player getViewer() {
        return this.viewer;
    }

    @NotNull
    public String getLang() {
        return Languages.getInstance().getLanguage(this.getViewer());
    }

    @Override
    @NotNull
    public UUID getViewerUUID() {
        return this.viewerUUID;
    }

    @Override
    public boolean isCloseable() {
        return this.closeable;
    }

    @Override
    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }

    @Override
    public boolean isOpen() {
        return this.currentlyOpen;
    }

    protected abstract void setInvItem(int var1, ItemStack var2);

    protected abstract SlotElement getSlotElement(int var1);

    protected abstract Pair<AbstractGui, Integer> getGuiAt(int var1);

    protected abstract AbstractGui[] getGuis();

    protected abstract org.bukkit.inventory.Inventory[] getInventories();

    protected abstract List<Inventory> getContentInventories();

    protected abstract void initItems();

    protected abstract void handleOpened();

    protected abstract void handleClosed();

    protected abstract void handleClick(InventoryClickEvent var1);

    protected abstract void handleItemShift(InventoryClickEvent var1);

    public abstract void handleViewerDeath(PlayerDeathEvent var1);

    public static abstract class AbstractBuilder<W extends Window, S extends Window.Builder<W, S>>
    implements Window.Builder<W, S> {
        protected Player viewer;
        protected ComponentWrapper title;
        protected boolean closeable = true;
        protected List<Runnable> openHandlers;
        protected List<Runnable> closeHandlers;
        protected List<Consumer<InventoryClickEvent>> outsideClickHandlers;
        protected List<Consumer<W>> modifiers;

        @Override
        @NotNull
        public S setViewer(@NotNull Player viewer) {
            this.viewer = viewer;
            return (S)this;
        }

        @Override
        @NotNull
        public S setTitle(@NotNull ComponentWrapper title) {
            this.title = title;
            return (S)this;
        }

        @Override
        @NotNull
        public S setTitle(@NotNull @NotNull BaseComponent @NotNull [] title) {
            this.title = new BungeeComponentWrapper(title);
            return (S)this;
        }

        @Override
        @NotNull
        public S setTitle(@NotNull String title) {
            this.title = new BungeeComponentWrapper(TextComponent.fromLegacyText((String)title));
            return (S)this;
        }

        @Override
        @NotNull
        public S setCloseable(boolean closeable) {
            this.closeable = closeable;
            return (S)this;
        }

        @Override
        @NotNull
        public S setOpenHandlers(@Nullable List<@NotNull Runnable> openHandlers) {
            this.openHandlers = openHandlers;
            return (S)this;
        }

        @Override
        @NotNull
        public S addOpenHandler(@NotNull Runnable openHandler) {
            if (this.openHandlers == null) {
                this.openHandlers = new ArrayList<Runnable>();
            }
            this.openHandlers.add(openHandler);
            return (S)this;
        }

        @Override
        @NotNull
        public S setCloseHandlers(@Nullable List<@NotNull Runnable> closeHandlers) {
            this.closeHandlers = closeHandlers;
            return (S)this;
        }

        @Override
        @NotNull
        public S addCloseHandler(@NotNull Runnable closeHandler) {
            if (this.closeHandlers == null) {
                this.closeHandlers = new ArrayList<Runnable>();
            }
            this.closeHandlers.add(closeHandler);
            return (S)this;
        }

        @Override
        @NotNull
        public S setOutsideClickHandlers(@NotNull @NotNull List<@NotNull Consumer<@NotNull InventoryClickEvent>> outsideClickHandlers) {
            this.outsideClickHandlers = outsideClickHandlers;
            return (S)this;
        }

        @Override
        @NotNull
        public S addOutsideClickHandler(@NotNull @NotNull Consumer<@NotNull InventoryClickEvent> outsideClickHandler) {
            if (this.outsideClickHandlers == null) {
                this.outsideClickHandlers = new ArrayList<Consumer<InventoryClickEvent>>();
            }
            this.outsideClickHandlers.add(outsideClickHandler);
            return (S)this;
        }

        @Override
        @NotNull
        public S setModifiers(@Nullable List<@NotNull Consumer<@NotNull W>> modifiers) {
            this.modifiers = modifiers;
            return (S)this;
        }

        @Override
        @NotNull
        public S addModifier(@NotNull @NotNull Consumer<@NotNull W> modifier) {
            if (this.modifiers == null) {
                this.modifiers = new ArrayList<Consumer<W>>();
            }
            this.modifiers.add(modifier);
            return (S)this;
        }

        protected void applyModifiers(W window) {
            if (this.openHandlers != null) {
                window.setOpenHandlers(this.openHandlers);
            }
            if (this.closeHandlers != null) {
                window.setCloseHandlers(this.closeHandlers);
            }
            if (this.outsideClickHandlers != null) {
                window.setOutsideClickHandlers(this.outsideClickHandlers);
            }
            if (this.modifiers != null) {
                this.modifiers.forEach(modifier -> modifier.accept(window));
            }
        }

        @Override
        @NotNull
        public W build() {
            return this.build(this.viewer);
        }

        @Override
        public void open(Player viewer) {
            this.build(viewer).open();
        }

        @Override
        @NotNull
        public S clone() {
            try {
                AbstractBuilder clone = (AbstractBuilder)super.clone();
                if (this.title != null) {
                    clone.title = this.title.clone();
                }
                if (this.closeHandlers != null) {
                    clone.closeHandlers = new ArrayList<Runnable>(this.closeHandlers);
                }
                if (this.modifiers != null) {
                    clone.modifiers = new ArrayList<Consumer<W>>(this.modifiers);
                }
                return (S)clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }
    }
}

