/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.window;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.inventoryaccess.InventoryAccess;
import xyz.xenondevs.inventoryaccess.abstraction.inventory.AnvilInventory;
import xyz.xenondevs.inventoryaccess.component.ComponentWrapper;
import xyz.xenondevs.invui.gui.AbstractGui;
import xyz.xenondevs.invui.window.AbstractSingleWindow;
import xyz.xenondevs.invui.window.AnvilWindow;

final class AnvilSingleWindowImpl
extends AbstractSingleWindow
implements AnvilWindow {
    private final AnvilInventory anvilInventory;

    public AnvilSingleWindowImpl(@NotNull Player player, @Nullable ComponentWrapper title, @NotNull AbstractGui gui, @Nullable List<@NotNull Consumer<@NotNull String>> renameHandlers, boolean closable) {
        super(player, title, gui, null, closable);
        this.anvilInventory = InventoryAccess.createAnvilInventory(player, title != null ? title.localized(player) : null, renameHandlers);
        this.inventory = this.anvilInventory.getBukkitInventory();
    }

    @Override
    protected void setInvItem(int slot, ItemStack itemStack) {
        this.anvilInventory.setItem(slot, itemStack);
    }

    @Override
    protected void openInventory(@NotNull Player viewer) {
        this.anvilInventory.open();
    }

    @Override
    public String getRenameText() {
        return this.anvilInventory.getRenameText();
    }

    public static final class BuilderImpl
    extends AbstractSingleWindow.AbstractBuilder<AnvilWindow, AnvilWindow.Builder.Single>
    implements AnvilWindow.Builder.Single {
        private List<Consumer<String>> renameHandlers;

        @Override
        @NotNull
        public BuilderImpl setRenameHandlers(@NotNull @NotNull List<@NotNull Consumer<String>> renameHandlers) {
            this.renameHandlers = renameHandlers;
            return this;
        }

        @Override
        @NotNull
        public BuilderImpl addRenameHandler(@NotNull Consumer<String> renameHandler) {
            if (this.renameHandlers == null) {
                this.renameHandlers = new ArrayList<Consumer<String>>();
            }
            this.renameHandlers.add(renameHandler);
            return this;
        }

        @Override
        @NotNull
        public AnvilWindow build(Player viewer) {
            if (viewer == null) {
                throw new IllegalStateException("Viewer is not defined.");
            }
            if (this.guiSupplier == null) {
                throw new IllegalStateException("Gui is not defined.");
            }
            AnvilSingleWindowImpl window = new AnvilSingleWindowImpl(viewer, this.title, (AbstractGui)this.guiSupplier.get(), this.renameHandlers, this.closeable);
            this.applyModifiers(window);
            return window;
        }
    }
}

