/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.common.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.ZipScanner;
import org.apache.tools.zip.ZipEntry;

public class ZipScannerTool {
    private ZipScannerTool() {
    }

    public static String[] getMatches(ZipFileSet fs, DirectoryScanner scanner) throws IOException {
        Collection result = ZipScannerTool.getMatchedCollection(fs, scanner);
        return result.toArray(new String[result.size()]);
    }

    public static Collection getMatchedCollection(ZipFileSet fs, DirectoryScanner scanner) throws IOException {
        return ZipScannerTool.getMatchedCollection(fs, scanner, "");
    }

    public static File zipFileSetGetSrc(ZipFileSet fs) {
        Method ant15 = null;
        Method ant16 = null;
        try {
            ant15 = fs.getClass().getMethod("getSrc", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            try {
                ant16 = fs.getClass().getMethod("getSrc", Project.class);
            }
            catch (NoSuchMethodException nsme2) {
                throw new BuildException("Could not determine getSrc method of ZipFileSet class");
            }
        }
        try {
            if (ant16 != null) {
                return (File)ant16.invoke((Object)fs, fs.getProject());
            }
            return (File)ant15.invoke((Object)fs, (Object[])null);
        }
        catch (IllegalAccessException iaex) {
            throw new BuildException("Could not invoke getSrc method of ZipFileSet class", iaex);
        }
        catch (InvocationTargetException itex) {
            if (itex.getTargetException() instanceof BuildException) {
                throw (BuildException)itex.getTargetException();
            }
            throw new BuildException("Internal error: getSrc invocation failed! " + itex.getTargetException().getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getMatchedCollection(ZipFileSet fs, DirectoryScanner scanner, String baseDir) throws IOException {
        ArrayList<String> result = new ArrayList<String>(20);
        File zipSrc = ZipScannerTool.zipFileSetGetSrc(fs);
        ZipScanner zipScanner = (ZipScanner)scanner;
        try (ZipInputStream in = null;){
            java.util.zip.ZipEntry origEntry;
            in = new ZipInputStream(new FileInputStream(zipSrc));
            while ((origEntry = in.getNextEntry()) != null) {
                ZipEntry entry = new ZipEntry(origEntry);
                String vPath = entry.getName();
                if (!zipScanner.match(vPath)) continue;
                result.add(vPath);
            }
        }
        return result;
    }
}

