/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.util.abstractjar.impl;

import com.yworks.util.abstractjar.Entry;
import java.io.File;
import java.nio.file.Path;

public class FileEntryWrapper
implements Entry {
    private File file;
    private String relative;

    FileEntryWrapper(File file, String relative) {
        this.relative = relative;
        this.file = file;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public String getName() {
        return this.relative;
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    public File getFile() {
        return this.file;
    }

    static FileEntryWrapper newRelativeInstance(File directory, Path file) {
        String relative = directory.toPath().relativize(file).toString();
        return new FileEntryWrapper(file.toFile(), relative.replace(File.separatorChar, '/'));
    }
}

