/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.util.graph;

import com.yworks.util.graph.Edge;
import com.yworks.util.graph.Network;
import com.yworks.util.graph.Node;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultNetwork
implements Network {
    private final List<Node> nodes = new ArrayList<Node>();
    private final List<Edge> edges = new ArrayList<Edge>();

    @Override
    public Object createNode() {
        Node node = new Node();
        this.nodes.add(node);
        return node;
    }

    @Override
    public Object createEdge(Object source, Object target) {
        Node src = (Node)source;
        Node tgt = (Node)target;
        Edge edge = new Edge(src, tgt);
        if (src.getOutEdges().size() > 0) {
            src.getOutEdges().get(src.getOutEdges().size() - 1).setNextOutEdge(edge);
        }
        src.addOutEdge(edge);
        if (tgt.getInEdges().size() > 0) {
            tgt.getInEdges().get(tgt.getInEdges().size() - 1).setNextInEdge(edge);
        }
        tgt.addInEdge(edge);
        this.edges.add(edge);
        return edge;
    }

    @Override
    public Object getSource(Object edge) {
        return ((Edge)edge).getSource();
    }

    @Override
    public Object getTarget(Object edge) {
        return ((Edge)edge).getTarget();
    }

    @Override
    public Iterator nodes() {
        return this.nodes.iterator();
    }

    @Override
    public Integer nodesSize() {
        return this.nodes.size();
    }

    @Override
    public Iterator edges() {
        return this.edges.iterator();
    }

    @Override
    public Iterator inEdges(Object node) {
        return ((Node)node).getInEdges().iterator();
    }

    @Override
    public Iterator outEdges(Object node) {
        return ((Node)node).getOutEdges().iterator();
    }

    @Override
    public Object firstInEdge(Object node) {
        Node n = (Node)node;
        return n.getInEdges().size() > 0 ? n.getInEdges().get(0) : null;
    }

    @Override
    public Object firstOutEdge(Object node) {
        Node n = (Node)node;
        return n.getOutEdges().size() > 0 ? n.getOutEdges().get(0) : null;
    }

    @Override
    public Object nextInEdge(Object edge) {
        return ((Edge)edge).getNextInEdge();
    }

    @Override
    public Object nextOutEdge(Object edge) {
        return ((Edge)edge).getNextOutEdge();
    }

    @Override
    public Iterator edgesConnecting(Object source, Object target) {
        Node src = (Node)source;
        Node tgt = (Node)target;
        ArrayList<Edge> edgesConnecting = new ArrayList<Edge>(src.getOutEdges().size());
        for (Edge e : src.getOutEdges()) {
            if (e.getTarget() != tgt) continue;
            edgesConnecting.add(e);
        }
        return edgesConnecting.iterator();
    }

    @Override
    public Object opposite(Object edge, Object node) {
        if (this.getSource(edge).equals(node)) {
            return this.getTarget(edge);
        }
        return this.getSource(edge);
    }
}

