/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard;

import com.yworks.yguard.obf.GuardDB;
import java.util.function.Function;
import java.util.regex.Pattern;

class ResourceAdjusterUtils {
    private ResourceAdjusterUtils() {
    }

    static String newContentPattern(String separator) {
        if (".".equals(separator)) {
            return "(?:\\w|[$])+(\\.(?:\\w|[$])+)+";
        }
        return "(?:\\w|[$])+((?:\\.|\\/)(?:\\w|[$])+)+";
    }

    public static Function<String, String> newTranslateJavaFileOrPath(GuardDB db) {
        return new TranslateJavaFileOrPath(db);
    }

    static Function<String, String> newTranslateJavaFile(GuardDB db, boolean strict) {
        return new TranslateJavaFile(db, strict);
    }

    static Function<String, String> newTranslateServiceFile(GuardDB db, boolean strict) {
        return new TranslateServiceFile(db, strict);
    }

    static Function<String, String> newTranslateJavaClass(GuardDB db) {
        return new TranslateJavaClass(db);
    }

    static Function<String, String> newTranslateMapping(GuardDB db, String separator, boolean strict) {
        if (".".equals(separator)) {
            return new TranslateJavaItem(db, strict);
        }
        if ("/".equals(separator)) {
            return new TranslatePathItem(db, strict);
        }
        return new TranslateItem(db, strict);
    }

    private static class TranslateJavaFileOrPath
    implements Function<String, String> {
        private final GuardDB db;

        TranslateJavaFileOrPath(GuardDB db) {
            this.db = db;
        }

        @Override
        public String apply(String identifier) {
            String mapped = this.db.translateJavaFile(identifier);
            return identifier.equals(mapped) ? this.db.getOutName(identifier) : mapped;
        }
    }

    private static final class TranslateServiceFile
    implements Function<String, String> {
        private final GuardDB db;
        private final boolean strict;

        TranslateServiceFile(GuardDB db, boolean strict) {
            this.db = db;
            this.strict = strict;
        }

        @Override
        public String apply(String identifier) {
            return this.strict ? this.db.translateJavaFile(identifier).replace('/', '.') : this.db.translateItem(identifier, '.', false);
        }
    }

    private static final class TranslateJavaFile
    implements Function<String, String> {
        private final GuardDB db;
        private final boolean strict;

        TranslateJavaFile(GuardDB db, boolean strict) {
            this.db = db;
            this.strict = strict;
        }

        @Override
        public String apply(String identifier) {
            return this.strict ? this.db.translateJavaFile(identifier) : this.db.translateItem(identifier, '/', false);
        }
    }

    private static final class TranslateJavaClass
    implements Function<String, String> {
        private final GuardDB db;

        TranslateJavaClass(GuardDB db) {
            this.db = db;
        }

        @Override
        public String apply(String identifier) {
            return this.db.translateJavaClass(identifier);
        }
    }

    private static final class TranslatePathItem
    implements Function<String, String> {
        private final GuardDB db;
        private final boolean strict;

        TranslatePathItem(GuardDB db, boolean strict) {
            this.db = db;
            this.strict = strict;
        }

        @Override
        public String apply(String identifier) {
            int sep = 47;
            int idxSlash = identifier.lastIndexOf(47);
            int idxExt = TranslatePathItem.indexOfExtension(identifier, idxSlash + 1);
            if (idxExt > -1) {
                String path = identifier.substring(0, idxExt);
                String ext = identifier.substring(idxExt);
                return this.db.translateItem(path, '/', this.strict) + ext;
            }
            return this.db.translateItem(identifier, '/', this.strict);
        }

        private static int indexOfExtension(String path, int fromIndex) {
            if (path.endsWith(".properties")) {
                int idx = path.indexOf(95, fromIndex);
                return idx > -1 ? idx : path.length() - 11;
            }
            return -1;
        }
    }

    private static final class TranslateJavaItem
    implements Function<String, String> {
        private final GuardDB db;
        private final boolean strict;

        TranslateJavaItem(GuardDB db, boolean strict) {
            this.db = db;
            this.strict = strict;
        }

        @Override
        public String apply(String identifier) {
            return this.db.translateItem(identifier, '.', this.strict);
        }
    }

    private static final class TranslateItem
    implements Function<String, String> {
        private final Pattern dot = Pattern.compile(ResourceAdjusterUtils.newContentPattern("."));
        private final TranslateJavaItem java;
        private final TranslatePathItem path;

        TranslateItem(GuardDB db, boolean strict) {
            this.java = new TranslateJavaItem(db, strict);
            this.path = new TranslatePathItem(db, strict);
        }

        @Override
        public String apply(String identifier) {
            if (this.dot.matcher(identifier).matches()) {
                return this.java.apply(identifier);
            }
            return this.path.apply(identifier);
        }
    }
}

