/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard;

import com.yworks.common.ShrinkBag;
import com.yworks.common.ant.AttributesSection;
import com.yworks.common.ant.Exclude;
import com.yworks.common.ant.YGuardBaseTask;
import com.yworks.logging.Logger;
import com.yworks.yguard.ObfuscatorTask;
import com.yworks.yguard.obf.Cl;
import com.yworks.yshrink.ant.ShrinkTask;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class YGuardTask
extends YGuardBaseTask {
    protected List<YGuardBaseTask> subTasks = new ArrayList<YGuardBaseTask>();

    @Override
    public void execute() throws BuildException {
        super.execute();
        if (null != this.pairs) {
            for (ShrinkBag pair : this.pairs) {
                for (YGuardBaseTask subTask : this.subTasks) {
                    subTask.addConfiguredInOutPair(pair);
                }
            }
        } else {
            throw new BuildException("No inoutpairs given. At least one inoutpair has to be specified.");
        }
        if (null != this.resourceClassPath) {
            for (YGuardBaseTask subTask : this.subTasks) {
                subTask.setResourceClassPath(this.resourceClassPath);
            }
        }
        if (null != this.attributesSections) {
            for (YGuardBaseTask subTask : this.subTasks) {
                subTask.addAttributesSections(this.attributesSections);
            }
        }
        Collections.sort(this.subTasks, new Comparator<YGuardBaseTask>(){

            @Override
            public int compare(YGuardBaseTask o1, YGuardBaseTask o2) {
                if (o1 instanceof ShrinkTask) {
                    return 0;
                }
                return 1;
            }
        });
        int taskNum = 0;
        File[] outFiles = new File[this.pairs.size()];
        File[] tempFiles = new File[this.pairs.size()];
        for (YGuardBaseTask subTask : this.subTasks) {
            for (int i = 0; i < this.pairs.size(); ++i) {
                ShrinkBag pair = (ShrinkBag)this.pairs.get(i);
                if (0 == taskNum) {
                    outFiles[i] = pair.getOut();
                } else {
                    if (taskNum > 1) {
                        pair.getIn().delete();
                    }
                    pair.setIn(pair.getOut());
                }
                if (taskNum == this.subTasks.size() - 1) {
                    pair.setOut(outFiles[i]);
                } else {
                    File tempFile;
                    tempFiles[i] = tempFile = this.getTempFile(pair.getOut());
                    pair.setOut(tempFile);
                }
                if (taskNum <= 1) continue;
                tempFiles[taskNum * (this.pairs.size() - 1) + i].delete();
            }
            subTask.execute();
            ++taskNum;
        }
        if (this.subTasks.size() > 1) {
            for (File tempFile : tempFiles) {
                tempFile.delete();
            }
        }
        Cl.setClassResolver(null);
    }

    private File getTempFile(File origFile) {
        try {
            File folder = new File(origFile.getParent());
            if (folder.exists()) {
                File tempFile = File.createTempFile("yguard_temp_", ".jar", folder);
                tempFile.deleteOnExit();
                return tempFile;
            }
            System.out.println("could not create temp file for " + origFile + " - parent folder does not exist: " + folder);
            return null;
        }
        catch (IOException e) {
            Logger.err("could not create temp file for " + origFile, e);
            throw new BuildException("could not create temp file for " + origFile);
        }
    }

    public ShrinkTask createShrink() {
        ShrinkTask shrinkTask = this.newShrinkTask(true);
        this.configureSubTask(shrinkTask);
        this.subTasks.add(shrinkTask);
        return shrinkTask;
    }

    protected ShrinkTask newShrinkTask(boolean mode) {
        return new ShrinkTask(mode);
    }

    public ObfuscatorTask createRename() {
        ObfuscatorTask obfuscatorTask = this.newObfuscatorTask(true);
        this.configureSubTask(obfuscatorTask);
        this.subTasks.add(obfuscatorTask);
        return obfuscatorTask;
    }

    protected ObfuscatorTask newObfuscatorTask(boolean mode) {
        return new ObfuscatorTask(mode);
    }

    private void configureSubTask(Task task) {
        task.setProject(this.getProject());
        task.setOwningTarget(this.getOwningTarget());
        task.setTaskName(this.getTaskName());
        task.setLocation(this.getLocation());
        task.setDescription(this.getDescription());
        task.init();
    }

    public ObfuscatorTask createObfuscate() {
        return this.createRename();
    }

    @Override
    public Exclude createKeep() {
        throw new BuildException("The keep element is allowed only in nested subtasks of the yguard task.");
    }

    @Override
    public void addAttributesSections(List<AttributesSection> attributesSections) {
    }
}

