/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.AttrInfo;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.MethodParameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MethodParametersAttrInfo
extends AttrInfo {
    private MethodParameter[] parameters;

    MethodParametersAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "MethodParameters";
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) {
        for (int i = 0; i < this.parameters.length; ++i) {
            int index = this.parameters[i].u2nameIndex;
            if (index <= 0) continue;
            pool.incRefCount(index);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException {
        int u1parameterCount = din.readUnsignedByte();
        this.parameters = new MethodParameter[u1parameterCount];
        for (int i = 0; i < u1parameterCount; ++i) {
            this.parameters[i] = MethodParameter.read(din);
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException {
        int u1parameterCount = this.parameters.length;
        dout.writeByte(u1parameterCount);
        for (int i = 0; i < u1parameterCount; ++i) {
            this.parameters[i].write(dout);
        }
    }
}

