/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.AttrInfo;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RecordComponent {
    static final int CONSTANT_FIELD_SIZE = 6;
    int u2nameIndex;
    int u2descriptorIndex;
    AttrInfo[] attributes;

    private RecordComponent(int nameIndex, int descriptorIndex, AttrInfo[] attributes) {
        this.u2nameIndex = nameIndex;
        this.u2descriptorIndex = descriptorIndex;
        this.attributes = attributes;
    }

    int getNameIndex() {
        return this.u2nameIndex;
    }

    void setNameIndex(int index) {
        this.u2nameIndex = index;
    }

    int getDescriptorIndex() {
        return this.u2descriptorIndex;
    }

    void setDescriptorIndex(int index) {
        this.u2descriptorIndex = index;
    }

    AttrInfo[] getAttributes() {
        return this.attributes;
    }

    boolean trimAttrsExcept(String[] keepAttrs) {
        int oldAttributesCount = this.attributes.length;
        this.attributes = AttrInfo.filter(this.attributes, keepAttrs);
        return oldAttributesCount != this.attributes.length;
    }

    void markUtf8Refs(ConstantPool pool) {
        pool.incRefCount(this.u2nameIndex);
        pool.incRefCount(this.u2descriptorIndex);
        int n = this.attributes.length;
        for (int i = 0; i < n; ++i) {
            this.attributes[i].markUtf8Refs(pool);
        }
    }

    static RecordComponent read(DataInput din, ClassFile cf) throws IOException {
        int nameIndex = din.readUnsignedShort();
        int descriptorIndex = din.readUnsignedShort();
        int attributesCount = din.readUnsignedShort();
        AttrInfo[] attributes = new AttrInfo[attributesCount];
        for (int i = 0; i < attributesCount; ++i) {
            attributes[i] = AttrInfo.create(din, cf);
        }
        return new RecordComponent(nameIndex, descriptorIndex, attributes);
    }

    void write(DataOutput dout) throws IOException {
        dout.writeShort(this.u2nameIndex);
        dout.writeShort(this.u2descriptorIndex);
        int u2attributesCount = this.attributes.length;
        dout.writeShort(u2attributesCount);
        for (int i = 0; i < u2attributesCount; ++i) {
            this.attributes[i].write(dout);
        }
    }
}

