/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.ant.filters;

import com.yworks.common.ant.TypePatternSet;
import com.yworks.yshrink.ant.FieldSection;
import com.yworks.yshrink.ant.filters.PatternMatchedFilter;
import com.yworks.yshrink.model.ClassDescriptor;
import com.yworks.yshrink.model.FieldDescriptor;
import com.yworks.yshrink.model.Model;
import com.yworks.yshrink.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.Project;
import org.objectweb.asm.Type;

public class FieldFilter
extends PatternMatchedFilter {
    private List<FieldSection> sections;

    public FieldFilter(Project project) {
        super(project);
    }

    public void addFieldSection(FieldSection fieldSection) {
        if (null == this.sections) {
            this.sections = new ArrayList<FieldSection>(5);
        }
        this.sections.add(fieldSection);
    }

    @Override
    public boolean isEntryPointField(Model model, ClassDescriptor cd, FieldDescriptor fd) {
        String className = cd.getName();
        String fieldName = fd.getName();
        for (FieldSection fs : this.sections) {
            boolean r = true;
            String entryFieldClass = fs.getClassName();
            String entryFieldName = fs.getName();
            if (null != fs.getType()) {
                Type requiredType = Type.getType(Util.verboseToNativeType(fs.getType()));
                r &= requiredType.equals(fd.getDesc());
            }
            if (null != fs.getAccess()) {
                r &= fs.getAccess().isAccessLevel(fd.getAccess());
            }
            r = null == entryFieldClass || entryFieldClass.length() == 0 ? (r &= this.match(TypePatternSet.Type.CLASS, className, fs) || this.match(TypePatternSet.Type.CLASS, Util.toJavaClass(className), fs)) : (r &= entryFieldClass.equals(className));
            r = null == entryFieldName || entryFieldName.length() == 0 ? (r &= this.match(TypePatternSet.Type.NAME, fieldName, fs)) : (r &= entryFieldName.equals(fieldName));
            if (!r) continue;
            return r;
        }
        return false;
    }
}

