/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.core;

import com.yworks.logging.Logger;
import com.yworks.logging.XmlLogger;
import com.yworks.yshrink.model.ClassDescriptor;
import com.yworks.yshrink.model.FieldDescriptor;
import com.yworks.yshrink.model.MethodDescriptor;
import com.yworks.yshrink.model.Model;
import com.yworks.yshrink.util.Util;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

public class OutputVisitor
extends ClassVisitor {
    private ClassVisitor cv;
    private Model model;
    private final boolean createStubs;
    private int numObsoleteMethods = 0;
    private int numObsoleteFields = 0;
    private ClassDescriptor currentClass;
    private final DoNothingAnnotationVisitor ignoreAnnotation = new DoNothingAnnotationVisitor();

    public OutputVisitor(ClassVisitor cv, Model model, boolean createStubs) {
        super(458752);
        this.createStubs = createStubs;
        this.cv = cv;
        this.model = model;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.currentClass = this.model.getClassDescriptor(name);
        if (this.model.isObsolete(this.currentClass.getNode())) {
            throw new IllegalArgumentException("Writing obsolete class: " + name);
        }
        this.cv.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public void visitSource(String source, String debug) {
        if (!this.currentClass.getRetainAttribute("SourceFile")) {
            source = null;
        }
        if (!this.currentClass.getRetainAttribute("SourceDebug")) {
            debug = null;
        }
        this.cv.visitSource(source, debug);
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        this.cv.visitOuterClass(owner, name, desc);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (visible ? !this.currentClass.getRetainAttribute("RuntimeVisibleAnnotations") : !this.currentClass.getRetainAttribute("RuntimeInvisibleAnnotations")) {
            return this.ignoreAnnotation;
        }
        return new OutputAnnotationVisitor(this.cv.visitAnnotation(desc, visible));
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        if (visible ? !this.currentClass.getRetainAttribute("RuntimeVisibleTypeAnnotations") : !this.currentClass.getRetainAttribute("RuntimeInvisibleAnnotations")) {
            return this.ignoreAnnotation;
        }
        return new OutputAnnotationVisitor(this.cv.visitTypeAnnotation(typeRef, typePath, descriptor, visible));
    }

    @Override
    public void visitAttribute(Attribute attr) {
        if (this.currentClass.getRetainAttribute(attr.type)) {
            this.cv.visitAttribute(attr);
        }
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        ClassDescriptor cd;
        if (this.model.isClassModeled(name) && !this.model.isObsolete((cd = this.model.getClassDescriptor(name)).getNode())) {
            this.cv.visitInnerClass(name, outerName, innerName, access);
        }
    }

    @Override
    public void visitNestHost(String nestHost) {
        ClassDescriptor cd = this.model.getClassDescriptor(nestHost);
        if (!this.model.isObsolete(cd.getNode())) {
            this.cv.visitNestHost(nestHost);
        }
    }

    @Override
    public void visitNestMember(String nestMember) {
        ClassDescriptor cd = this.model.getClassDescriptor(nestMember);
        if (!this.model.isObsolete(cd.getNode()) && this.currentClass.getHasNestMembers()) {
            this.cv.visitNestMember(nestMember);
        }
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldDescriptor fd = this.currentClass.getField(name);
        if (this.model.isObsolete(fd.getNode())) {
            Logger.shrinkLog("\t\t<field name=\"" + name + "\" class=\"" + Util.toJavaClass(this.currentClass.getName()) + "\" />");
            ++this.numObsoleteFields;
            return null;
        }
        return new OutputFieldVisitor(this.cv.visitField(access, name, desc, signature, value));
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodDescriptor md = this.currentClass.getMethod(name, desc);
        if (this.model.isObsolete(md.getNode())) {
            if (!this.model.isStubNeeded(md.getNode())) {
                ++this.numObsoleteMethods;
                Logger.shrinkLog("\t\t<method signature=\"" + XmlLogger.replaceSpecialChars(md.getSignature()) + "\" class=\"" + Util.toJavaClass(this.currentClass.getName()) + "\" />");
            }
            if (this.createStubs || this.model.isStubNeeded(md.getNode())) {
                boolean visitStub = !md.hasFlag(1024);
                return new StubOutputMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions), visitStub);
            }
            return null;
        }
        return new OutputMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
    }

    private void visitStub(MethodVisitor mv) {
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/InternalError");
        mv.visitInsn(89);
        mv.visitLdcInsn("Badly shrinked");
        mv.visitMethodInsn(183, "java/lang/InternalError", "<init>", "(Ljava/lang/String;)V", this.currentClass.isInterface());
        mv.visitInsn(191);
        mv.visitMaxs(3, 1);
    }

    @Override
    public void visitEnd() {
        this.cv.visitEnd();
    }

    public int getNumObsoleteMethods() {
        return this.numObsoleteMethods;
    }

    public int getNumObsoleteFields() {
        return this.numObsoleteFields;
    }

    class OutputAnnotationVisitor
    extends AnnotationVisitor {
        AnnotationVisitor delegate;

        public OutputAnnotationVisitor(AnnotationVisitor delegate) {
            super(458752);
            this.delegate = delegate;
        }

        @Override
        public void visit(String name, Object value) {
            this.delegate.visit(name, value);
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.delegate.visitEnum(name, desc, value);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new OutputAnnotationVisitor(this.delegate.visitAnnotation(name, desc));
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return new OutputAnnotationVisitor(this.delegate.visitArray(name));
        }

        @Override
        public void visitEnd() {
            this.delegate.visitEnd();
        }
    }

    static class DoNothingAnnotationVisitor
    extends AnnotationVisitor {
        public DoNothingAnnotationVisitor() {
            super(458752);
        }

        @Override
        public void visit(String name, Object value) {
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return this;
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return this;
        }

        @Override
        public void visitEnd() {
        }
    }

    class StubOutputMethodVisitor
    extends MethodVisitor {
        private MethodVisitor delegate;
        private final boolean visitStub;

        public StubOutputMethodVisitor(MethodVisitor delegate, boolean visitStub) {
            super(458752);
            this.delegate = delegate;
            this.visitStub = visitStub;
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return this.delegate.visitAnnotationDefault();
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (visible ? !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeVisibleAnnotations") : !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeInvisibleAnnotations")) {
                return OutputVisitor.this.ignoreAnnotation;
            }
            return new OutputAnnotationVisitor(this.delegate.visitAnnotation(desc, visible));
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            if (visible ? !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeVisibleParameterAnnotations") : !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeInvisibleParameterAnnotations")) {
                return OutputVisitor.this.ignoreAnnotation;
            }
            return new OutputAnnotationVisitor(this.delegate.visitParameterAnnotation(parameter, desc, visible));
        }

        @Override
        public void visitAttribute(Attribute attr) {
            if (OutputVisitor.this.currentClass.getRetainAttribute(attr.type)) {
                this.delegate.visitAttribute(attr);
            }
        }

        @Override
        public void visitCode() {
        }

        @Override
        public void visitFrame(int i, int i1, Object[] objects, int i2, Object[] objects1) {
        }

        @Override
        public void visitInsn(int opcode) {
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
        }

        @Override
        public void visitTypeInsn(int opcode, String desc) {
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
        }

        @Override
        public void visitLabel(Label label) {
        }

        @Override
        public void visitLdcInsn(Object cst) {
        }

        @Override
        public void visitIincInsn(int var, int increment) {
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
        }

        @Override
        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        }

        @Override
        public void visitLineNumber(int line, Label start) {
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
        }

        @Override
        public void visitEnd() {
            if (this.visitStub) {
                OutputVisitor.this.visitStub(this.delegate);
            }
            this.delegate.visitEnd();
        }
    }

    class OutputFieldVisitor
    extends FieldVisitor {
        private final FieldVisitor delegate;

        public OutputFieldVisitor(FieldVisitor delegate) {
            super(458752);
            this.delegate = delegate;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (visible ? !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeVisibleAnnotations") : !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeInvisibleAnnotations")) {
                return OutputVisitor.this.ignoreAnnotation;
            }
            return new OutputAnnotationVisitor(this.delegate.visitAnnotation(desc, visible));
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            if (visible ? !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeVisibleTypeAnnotations") : !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeInvisibleTypeAnnotations")) {
                return OutputVisitor.this.ignoreAnnotation;
            }
            return new OutputAnnotationVisitor(this.delegate.visitTypeAnnotation(typeRef, typePath, descriptor, visible));
        }

        @Override
        public void visitAttribute(Attribute attribute) {
            if (OutputVisitor.this.currentClass.getRetainAttribute(attribute.type)) {
                this.delegate.visitAttribute(attribute);
            }
        }

        @Override
        public void visitEnd() {
            this.delegate.visitEnd();
        }
    }

    class OutputMethodVisitor
    extends MethodVisitor {
        private MethodVisitor delegate;

        public OutputMethodVisitor(MethodVisitor delegate) {
            super(458752);
            this.delegate = delegate;
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return this.delegate.visitAnnotationDefault();
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (visible ? !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeVisibleAnnotations") : !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeInvisibleAnnotations")) {
                return OutputVisitor.this.ignoreAnnotation;
            }
            return new OutputAnnotationVisitor(this.delegate.visitAnnotation(desc, visible));
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            if (visible ? !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeVisibleParameterAnnotations") : !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeInvisibleParameterAnnotations")) {
                return OutputVisitor.this.ignoreAnnotation;
            }
            return new OutputAnnotationVisitor(this.delegate.visitParameterAnnotation(parameter, desc, visible));
        }

        @Override
        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            if (visible ? !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeVisibleTypeAnnotations") : !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeInvisibleTypeAnnotations")) {
                return OutputVisitor.this.ignoreAnnotation;
            }
            return new OutputAnnotationVisitor(this.delegate.visitInsnAnnotation(typeRef, typePath, descriptor, visible));
        }

        @Override
        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
            if (visible ? !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeVisibleTypeAnnotations") : !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeInvisibleTypeAnnotations")) {
                return OutputVisitor.this.ignoreAnnotation;
            }
            return new OutputAnnotationVisitor(this.delegate.visitLocalVariableAnnotation(typeRef, typePath, start, end, index, descriptor, visible));
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            if (visible ? !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeVisibleTypeAnnotations") : !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeInvisibleTypeAnnotations")) {
                return OutputVisitor.this.ignoreAnnotation;
            }
            return new OutputAnnotationVisitor(this.delegate.visitTypeAnnotation(typeRef, typePath, descriptor, visible));
        }

        @Override
        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            if (visible ? !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeVisibleTypeAnnotations") : !OutputVisitor.this.currentClass.getRetainAttribute("RuntimeInvisibleTypeAnnotations")) {
                return OutputVisitor.this.ignoreAnnotation;
            }
            return new OutputAnnotationVisitor(this.delegate.visitTryCatchAnnotation(typeRef, typePath, descriptor, visible));
        }

        @Override
        public void visitAttribute(Attribute attr) {
            if (OutputVisitor.this.currentClass.getRetainAttribute(attr.type)) {
                this.delegate.visitAttribute(attr);
            }
        }

        @Override
        public void visitCode() {
            this.delegate.visitCode();
        }

        @Override
        public void visitFrame(int i, int i1, Object[] objects, int i2, Object[] objects1) {
            this.delegate.visitFrame(i, i1, objects, i2, objects1);
        }

        @Override
        public void visitInsn(int opcode) {
            this.delegate.visitInsn(opcode);
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            this.delegate.visitIntInsn(opcode, operand);
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            this.delegate.visitVarInsn(opcode, var);
        }

        @Override
        public void visitTypeInsn(int opcode, String desc) {
            this.delegate.visitTypeInsn(opcode, desc);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.delegate.visitFieldInsn(opcode, owner, name, desc);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            this.delegate.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            this.delegate.visitJumpInsn(opcode, label);
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            this.delegate.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
        }

        @Override
        public void visitLabel(Label label) {
            this.delegate.visitLabel(label);
        }

        @Override
        public void visitLdcInsn(Object cst) {
            this.delegate.visitLdcInsn(cst);
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            this.delegate.visitIincInsn(var, increment);
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            this.delegate.visitTableSwitchInsn(min, max, dflt, labels);
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.delegate.visitLookupSwitchInsn(dflt, keys, labels);
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.delegate.visitMultiANewArrayInsn(desc, dims);
        }

        @Override
        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.delegate.visitTryCatchBlock(start, end, handler, type);
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (null != signature ? !OutputVisitor.this.currentClass.getRetainAttribute("LocalVariableTypeTable") : !OutputVisitor.this.currentClass.getRetainAttribute("LocalVariableTable")) {
                return;
            }
            this.delegate.visitLocalVariable(name, desc, signature, start, end, index);
        }

        @Override
        public void visitLineNumber(int line, Label start) {
            if (OutputVisitor.this.currentClass.getRetainAttribute("LineNumberTable")) {
                this.delegate.visitLineNumber(line, start);
            }
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            this.delegate.visitMaxs(maxStack, maxLocals);
        }

        @Override
        public void visitEnd() {
            this.delegate.visitEnd();
        }
    }
}

