/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin;

import fr.fuzeblocks.homeplugin.bstats.bukkit.Metrics;
import fr.fuzeblocks.homeplugin.cache.CacheManager;
import fr.fuzeblocks.homeplugin.commands.BackCommand;
import fr.fuzeblocks.homeplugin.commands.CacheCommand;
import fr.fuzeblocks.homeplugin.commands.LangCommand;
import fr.fuzeblocks.homeplugin.commands.PluginCommand;
import fr.fuzeblocks.homeplugin.commands.home.DeleteHomeCommand;
import fr.fuzeblocks.homeplugin.commands.home.HomeAdminCommand;
import fr.fuzeblocks.homeplugin.commands.home.HomeCommand;
import fr.fuzeblocks.homeplugin.commands.home.ListHomeCommand;
import fr.fuzeblocks.homeplugin.commands.home.RelocateHomeCommand;
import fr.fuzeblocks.homeplugin.commands.home.RenameHomeCommand;
import fr.fuzeblocks.homeplugin.commands.home.SetHomeCommand;
import fr.fuzeblocks.homeplugin.commands.rtp.RTPCommand;
import fr.fuzeblocks.homeplugin.commands.spawn.DeleteSpawnCommand;
import fr.fuzeblocks.homeplugin.commands.spawn.SetSpawnCommand;
import fr.fuzeblocks.homeplugin.commands.spawn.SpawnCommand;
import fr.fuzeblocks.homeplugin.commands.tpa.TPAAcceptCommand;
import fr.fuzeblocks.homeplugin.commands.tpa.TPACommand;
import fr.fuzeblocks.homeplugin.commands.tpa.TPADenyCommand;
import fr.fuzeblocks.homeplugin.completers.CacheCompleter;
import fr.fuzeblocks.homeplugin.completers.DeleteHomeCompleter;
import fr.fuzeblocks.homeplugin.completers.HomeAdminCompleter;
import fr.fuzeblocks.homeplugin.completers.HomeCompleter;
import fr.fuzeblocks.homeplugin.completers.LangTabCompleter;
import fr.fuzeblocks.homeplugin.completers.RelocateHomeCompleter;
import fr.fuzeblocks.homeplugin.completers.RenameHomeCompleter;
import fr.fuzeblocks.homeplugin.completers.SetHomeCompleter;
import fr.fuzeblocks.homeplugin.completers.TpAcceptCompleter;
import fr.fuzeblocks.homeplugin.completers.TpDenyCompleter;
import fr.fuzeblocks.homeplugin.completers.TpaCompleter;
import fr.fuzeblocks.homeplugin.database.CreateTable;
import fr.fuzeblocks.homeplugin.database.DatabaseConnection;
import fr.fuzeblocks.homeplugin.database.DatabaseManager;
import fr.fuzeblocks.homeplugin.economy.EconomyManager;
import fr.fuzeblocks.homeplugin.home.HomeManager;
import fr.fuzeblocks.homeplugin.home.sql.HomeSQLManager;
import fr.fuzeblocks.homeplugin.home.yml.HomeYMLManager;
import fr.fuzeblocks.homeplugin.language.Language;
import fr.fuzeblocks.homeplugin.language.LanguageManager;
import fr.fuzeblocks.homeplugin.listeners.BackListener;
import fr.fuzeblocks.homeplugin.listeners.OnJoinListener;
import fr.fuzeblocks.homeplugin.listeners.OnMoveListener;
import fr.fuzeblocks.homeplugin.listeners.OnPlayerTakeDamageByAnotherPlayer;
import fr.fuzeblocks.homeplugin.placeholder.HomePluginExpansion;
import fr.fuzeblocks.homeplugin.plugin.PluginManager;
import fr.fuzeblocks.homeplugin.spawn.SpawnManager;
import fr.fuzeblocks.homeplugin.spawn.sql.SpawnSQLManager;
import fr.fuzeblocks.homeplugin.spawn.yml.SpawnYMLManager;
import fr.fuzeblocks.homeplugin.sync.SyncMethod;
import fr.fuzeblocks.homeplugin.update.UpdateChecker;
import fr.fuzeblocks.libs.net.kyori.adventure.platform.bukkit.BukkitAudiences;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NonNull;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisPooled;

public final class HomePlugin
extends JavaPlugin {
    private static final String CFG_ROOT = "Config.";
    private static final String CFG_CONNECTOR = "Config.Storage.TYPE";
    private static final String CFG_LANGUAGE = "Config.Language";
    private static final String CFG_REDIS_USE = "Config.Redis.Use-Redis";
    private static final String CFG_REDIS_HOST = "Config.Redis.HOST";
    private static final String CFG_REDIS_PORT = "Config.Redis.PORT";
    private static final String CFG_REDIS_SSL = "Config.Redis.SSL";
    private static final String CFG_REDIS_PASSWORD = "Config.Redis.PASSWORD";
    private static final String CFG_RTP_ENABLED = "Config.RTP.Enabled";
    private static HomeYMLManager homeYMLManager;
    private static SpawnYMLManager spawnYMLManager;
    private static CacheManager cacheManager;
    private static HomeSQLManager homeSQLManager;
    private static SpawnSQLManager spawnSQLManager;
    private static ConfigurationSection configurationSection;
    private static JedisPooled jedisPooled;
    private static HomeManager homeManager;
    private static SpawnManager spawnManager;
    private static LanguageManager languageManager;
    private static BukkitAudiences adventure;
    private static Economy economy;
    private static Metrics metrics;

    public void onEnable() {
        this.saveDefaultConfig();
        this.applyDefaultConfigValues();
        configurationSection = this.getConfig();
        adventure = BukkitAudiences.create((Plugin)this);
        this.setupMetrics();
        this.setupEconomy();
        this.checkDepend();
        this.loadLanguage();
        this.redisRegistration();
        this.databaseRegistration();
        this.homeRegistration();
        this.spawnRegistration();
        cacheManager = CacheManager.getInstance();
        this.commandRegistration();
        this.eventRegistration();
        this.completerRegistration();
        this.countPlugins();
        this.initPluginFunc();
        this.checkUpdate(113935);
        this.getLogger().info("------------------------------------------------------");
        this.getLogger().info("HomePlugin started successfully!");
        this.getLogger().info("Language: " + this.getConfig().getString(CFG_LANGUAGE));
        this.getLogger().info("Storage: " + this.getConfig().getString(CFG_CONNECTOR));
        this.getLogger().info("------------------------------------------------------");
    }

    public void onDisable() {
        if (adventure != null) {
            adventure.close();
            adventure = null;
        }
        if (jedisPooled != null) {
            try {
                jedisPooled.close();
            }
            catch (Exception exception) {
            }
            finally {
                jedisPooled = null;
            }
        }
        this.stopPluginFunc();
        this.getLogger().info("------------------------------------------------------");
        this.getLogger().info("HomePlugin shut down successfully!");
        this.getLogger().info("------------------------------------------------------");
    }

    private void applyDefaultConfigValues() {
        this.getConfig().addDefault(CFG_CONNECTOR, (Object)"YAML");
        this.getConfig().addDefault(CFG_LANGUAGE, (Object)"FRENCH");
        this.getConfig().addDefault(CFG_REDIS_USE, (Object)false);
        this.getConfig().addDefault(CFG_REDIS_HOST, (Object)"127.0.0.1");
        this.getConfig().addDefault(CFG_REDIS_PORT, (Object)6379);
        this.getConfig().addDefault(CFG_REDIS_SSL, (Object)false);
        this.getConfig().addDefault(CFG_REDIS_PASSWORD, (Object)"");
        this.getConfig().addDefault(CFG_RTP_ENABLED, (Object)false);
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
    }

    private void checkDepend() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new HomePluginExpansion(this).register();
            this.getLogger().info("PlaceholderAPI detected. Placeholders enabled.");
        } else {
            this.getLogger().warning("PlaceholderAPI not installed. Placeholders disabled.");
        }
    }

    private void loadLanguage() {
        Language language;
        String languageString = this.getConfig().getString(CFG_LANGUAGE, "FRENCH");
        try {
            language = Language.valueOf(languageString.toUpperCase());
        }
        catch (Exception e) {
            this.getLogger().warning("Invalid language '" + languageString + "'. Falling back to FRENCH.");
            language = Language.FRENCH;
        }
        languageManager = new LanguageManager(language, this);
    }

    private void redisRegistration() {
        if (!this.getConfig().getBoolean(CFG_REDIS_USE, false)) {
            this.getLogger().info("Redis disabled in config. Skipping Redis setup.");
            return;
        }
        try {
            DefaultJedisClientConfig jedisClientConfig = DefaultJedisClientConfig.builder().password(HomePlugin.blankToNull(this.getConfig().getString(CFG_REDIS_PASSWORD))).ssl(this.getConfig().getBoolean(CFG_REDIS_SSL, false)).build();
            HostAndPort hostAndPort = new HostAndPort(this.getConfig().getString(CFG_REDIS_HOST, "127.0.0.1"), this.getConfig().getInt(CFG_REDIS_PORT, 6379));
            jedisPooled = new JedisPooled(hostAndPort, (JedisClientConfig)jedisClientConfig);
            jedisPooled.ping();
            this.getLogger().info("Redis registered successfully!");
        }
        catch (Exception e) {
            this.getLogger().warning("Cannot connect to Redis (" + e.getClass().getSimpleName() + ": " + e.getMessage() + "). Falling back to default cache.");
            jedisPooled = null;
        }
    }

    private void databaseRegistration() {
        String connector = this.getConfig().getString(CFG_CONNECTOR, "YAML");
        if ("MYSQL".equalsIgnoreCase(connector)) {
            this.getLogger().info("Setting up MySQL storage...");
            try {
                new DatabaseManager(this);
                new CreateTable(DatabaseConnection.getConnection());
                homeSQLManager = new HomeSQLManager();
                spawnSQLManager = new SpawnSQLManager();
                this.getLogger().info("MySQL storage initialized.");
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to initialize MySQL storage: " + e.getMessage());
            }
        } else {
            this.getLogger().info("Using YAML storage.");
        }
    }

    private void homeRegistration() {
        this.getLogger().info("Registering Homes...");
        File home = new File(this.getDataFolder(), "homes.yml");
        this.ensureFile(home);
        homeYMLManager = new HomeYMLManager(home);
        homeManager = HomeManager.getInstance();
    }

    private void spawnRegistration() {
        this.getLogger().info("Registering Spawns...");
        File spawn = new File(this.getDataFolder(), "spawn.yml");
        this.ensureFile(spawn);
        spawnYMLManager = new SpawnYMLManager(spawn);
        spawnManager = SpawnManager.getInstance();
    }

    private void ensureFile(File file) {
        if (!this.getDataFolder().exists() && !this.getDataFolder().mkdirs()) {
            this.getLogger().severe("[HomePlugin] Cannot create plugin data folder. Disabling plugin...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    throw new IOException("createNewFile returned false");
                }
            }
            catch (IOException e) {
                this.getLogger().severe("[HomePlugin] Cannot create file " + file.getName() + " (" + e.getMessage() + "). Disabling plugin...");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
            }
        }
    }

    private void commandRegistration() {
        this.getLogger().info("Registering commands...");
        this.bind("home", new HomeCommand(), new HomeCompleter());
        this.bind("sethome", new SetHomeCommand(), new SetHomeCompleter());
        this.bind("delhome", new DeleteHomeCommand(), new DeleteHomeCompleter());
        this.bind("renamehome", new RenameHomeCommand(), new RenameHomeCompleter());
        this.bind("relocatehome", new RelocateHomeCommand(), new RelocateHomeCompleter());
        this.bind("listhome", new ListHomeCommand(), null);
        this.bind("setspawn", new SetSpawnCommand(), null);
        this.bind("delspawn", new DeleteSpawnCommand(), null);
        this.bind("spawn", new SpawnCommand(), null);
        this.bind("cache", new CacheCommand(), new CacheCompleter());
        this.bind("homeadmin", new HomeAdminCommand(), new HomeAdminCompleter());
        this.bind("plugins", new PluginCommand(), null);
        this.bind("lang", new LangCommand((Plugin)this), new LangTabCompleter((Plugin)this));
        this.bind("tpa", new TPACommand(), new TpaCompleter());
        this.bind("tpaccept", new TPAAcceptCommand(), new TpAcceptCompleter());
        this.bind("tpdeny", new TPADenyCommand(), new TpDenyCompleter());
        this.bind("back", new BackCommand(), null);
        if (this.getConfig().getBoolean(CFG_RTP_ENABLED, false)) {
            this.bind("rtp", new RTPCommand(), null);
        }
    }

    private void eventRegistration() {
        this.getLogger().info("Registering events...");
        Bukkit.getPluginManager().registerEvents((Listener)new OnJoinListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnMoveListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnPlayerTakeDamageByAnotherPlayer(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BackListener(), (Plugin)this);
    }

    private void completerRegistration() {
    }

    private void checkUpdate(int id) {
        new UpdateChecker(this, id).getVersion(version -> {
            try {
                String local = HomePlugin.safeDigits(this.getDescription().getVersion());
                String remote = HomePlugin.safeDigits(version);
                int localVersion = Integer.parseInt(local.replace(".", ""));
                int remoteVersion = Integer.parseInt(remote.replace(".", ""));
                if (remoteVersion > localVersion) {
                    this.getLogger().warning("A new update is available. Current: " + local + " | Latest: " + remote);
                }
            }
            catch (Exception e) {
                this.getLogger().fine("Could not compare versions: " + e.getMessage());
            }
        });
    }

    private void initPluginFunc() {
        fr.fuzeblocks.homeplugin.plugin.HomePlugin plug = this.getFirstHomePlugin();
        if (plug != null) {
            try {
                plug.initialize();
                this.getLogger().info(plug.getName() + " plugin initialized.");
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to initialize plugin extension: " + e.getMessage());
            }
        }
    }

    private void stopPluginFunc() {
        fr.fuzeblocks.homeplugin.plugin.HomePlugin plug = this.getFirstHomePlugin();
        if (plug != null) {
            try {
                plug.stop();
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to stop plugin extension: " + e.getMessage());
            }
        }
    }

    private fr.fuzeblocks.homeplugin.plugin.HomePlugin getFirstHomePlugin() {
        List<fr.fuzeblocks.homeplugin.plugin.HomePlugin> plugins = PluginManager.getInstance().getHomePlugin();
        return plugins == null || plugins.isEmpty() ? null : plugins.get(0);
    }

    private void countPlugins() {
        int count = PluginManager.getInstance().getHomePlugin().size();
        if (count == 0) {
            this.getLogger().warning("No plugin extensions detected.");
        } else {
            this.getLogger().info("Loaded " + count + " plugin extension(s).");
        }
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().info("Vault not found. Economy features disabled.");
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.getLogger().info("No Economy provider found. Economy features disabled.");
            return false;
        }
        economy = (Economy)rsp.getProvider();
        EconomyManager.setup(this);
        return economy != null;
    }

    private void setupMetrics() {
        metrics = new Metrics(this, 27702);
    }

    private void bind(String name, CommandExecutor exec, TabCompleter tab) {
        org.bukkit.command.PluginCommand c = this.getCommand(name);
        if (c == null) {
            this.getLogger().warning("Command '" + name + "' not found in plugin.yml. Skipping registration.");
            return;
        }
        if (exec != null) {
            c.setExecutor(exec);
        }
        if (tab != null) {
            c.setTabCompleter(tab);
        }
    }

    private static String safeDigits(String ver) {
        return ver == null ? "0" : ver.replaceAll("[^0-9.]", "");
    }

    private static String blankToNull(String s) {
        return s == null || s.isBlank() ? null : s;
    }

    public static HomeYMLManager getHomeYMLManager() {
        return homeYMLManager;
    }

    public static SpawnYMLManager getSpawnYMLManager() {
        return spawnYMLManager;
    }

    public static CacheManager getCacheManager() {
        return cacheManager;
    }

    public static HomeSQLManager getHomeSQLManager() {
        return homeSQLManager;
    }

    public static SpawnSQLManager getSpawnSQLManager() {
        return spawnSQLManager;
    }

    public static SyncMethod getRegistrationType() {
        String type = configurationSection != null ? configurationSection.getString(CFG_CONNECTOR, "YAML") : "YAML";
        return "MYSQL".equalsIgnoreCase(type) ? SyncMethod.MYSQL : SyncMethod.YAML;
    }

    public static ConfigurationSection getConfigurationSection() {
        return configurationSection;
    }

    public static JedisPooled getJedisPooled() {
        return jedisPooled;
    }

    public static HomeManager getHomeManager() {
        return homeManager;
    }

    public static SpawnManager getSpawnManager() {
        return spawnManager;
    }

    public static LanguageManager getLanguageManager() {
        return languageManager;
    }

    public static Economy getEconomy() {
        return economy;
    }

    public static @NonNull BukkitAudiences getAdventure() {
        if (adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return adventure;
    }

    public static Metrics getMetrics() {
        return metrics;
    }
}

