/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.back;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class BackManager {
    private static BackManager instance = null;
    private final Map<UUID, Location> lastLocations = new ConcurrentHashMap<UUID, Location>();

    public static BackManager getInstance() {
        if (instance == null) {
            instance = new BackManager();
        }
        return instance;
    }

    public void setLastLocation(Player player, Location location) {
        if (player == null || location == null) {
            return;
        }
        this.lastLocations.put(player.getUniqueId(), location.clone());
    }

    public Optional<Location> getLastLocation(Player player) {
        if (player == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.lastLocations.get(player.getUniqueId()));
    }

    public boolean hasLastLocation(Player player) {
        if (player == null) {
            return false;
        }
        return this.lastLocations.containsKey(player.getUniqueId());
    }

    public void clear(Player player) {
        if (player == null) {
            return;
        }
        this.lastLocations.remove(player.getUniqueId());
    }
}

