/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.commands;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.language.LanguageManager;
import fr.fuzeblocks.homeplugin.language.LanguageMerge;
import java.io.File;
import java.io.IOException;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class LangCommand
implements CommandExecutor {
    private final Plugin plugin;
    private static final String LANG = "LangCommand.";
    private static final LanguageManager languageManager = HomePlugin.getLanguageManager();

    public LangCommand(Plugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String sub;
        if (args.length < 1) {
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-usage-message"));
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "update": {
                return this.handleUpdate(sender, args);
            }
            case "merge": {
                return this.handleMerge(sender, args);
            }
            case "set": {
                return this.handleSet(sender, args);
            }
        }
        sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-unknown-subcommand"));
        return true;
    }

    private boolean handleUpdate(CommandSender sender, String[] args) {
        if (args.length != 1) {
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-update-usage"));
            return true;
        }
        String langName = languageManager.getLanguage().name().toLowerCase();
        File oldFile = new File(this.plugin.getDataFolder(), langName + ".yml");
        if (!oldFile.exists()) {
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-file-not-exist").replace("%file%", oldFile.getName()));
            return true;
        }
        File backupFile = new File(this.plugin.getDataFolder(), langName + "_backup.yml");
        if (backupFile.exists() && !backupFile.delete()) {
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-backup-delete-fail"));
            return true;
        }
        if (!oldFile.renameTo(backupFile)) {
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-backup-fail"));
            return true;
        }
        if (!languageManager.regenerate()) {
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-regeneration-fail"));
            if (!backupFile.renameTo(oldFile)) {
                sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-restore-fail"));
            }
            return true;
        }
        File newFile = new File(this.plugin.getDataFolder(), langName + ".yml");
        if (!newFile.exists()) {
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-new-file-missing").replace("%file%", newFile.getName()));
            if (!backupFile.renameTo(oldFile)) {
                sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-restore-fail"));
            }
            return true;
        }
        LanguageMerge merger = new LanguageMerge(backupFile, newFile);
        merger.mergeAddOnly();
        if (!merger.pushTo(newFile)) {
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-merge-error"));
            return true;
        }
        sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-merge-success"));
        return true;
    }

    private boolean handleMerge(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-merge-usage"));
            return true;
        }
        File editedFile = new File(this.plugin.getDataFolder(), args[1]);
        File latestFile = new File(this.plugin.getDataFolder(), args[2]);
        if (!editedFile.exists()) {
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-merge-edited-missing").replace("%file%", args[1]));
            return true;
        }
        if (!latestFile.exists()) {
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-merge-latest-missing").replace("%file%", args[2]));
            return true;
        }
        LanguageMerge merger = new LanguageMerge(editedFile, latestFile);
        merger.mergeAddOnly();
        if (merger.pushChanges()) {
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-merge-saved"));
        } else {
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-merge-fail"));
        }
        return true;
    }

    private boolean handleSet(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-set-usage"));
            return true;
        }
        String newLang = args[1].toUpperCase();
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-config-missing"));
            return true;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        config.set("Config.Language", (Object)newLang);
        try {
            config.save(configFile);
            this.plugin.reloadConfig();
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-set-success").replace("%lang%", newLang));
        }
        catch (IOException e) {
            sender.sendMessage(languageManager.getStringWithColor("LangCommand.Lang-config-save-fail"));
            e.printStackTrace();
        }
        return true;
    }
}

