/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.commands;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.language.LanguageManager;
import fr.fuzeblocks.homeplugin.plugin.PluginManager;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PluginCommand
implements CommandExecutor {
    private static final String PLUGIN_COMMAND = "PluginCommand.";
    private static final String LANGUAGE = "Language.";

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.translate("Language.Only-a-player-can-execute"));
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("homeplugin.admin")) {
            player.sendMessage(this.translate("Language.No-permission"));
            return false;
        }
        this.sendMessage(player);
        return true;
    }

    private void sendMessage(Player player) {
        PluginManager pluginManager = PluginManager.getInstance();
        if (pluginManager == null) {
            player.sendMessage(this.translate("PluginCommand.Plugin-manager-not-initialized"));
            return;
        }
        List<fr.fuzeblocks.homeplugin.plugin.HomePlugin> plugins = pluginManager.getHomePlugin();
        if (plugins == null || plugins.isEmpty()) {
            player.sendMessage(this.translate("PluginCommand.No-plugins-loaded"));
            return;
        }
        player.sendMessage(this.translate("PluginCommand.Plugin-list-header"));
        for (fr.fuzeblocks.homeplugin.plugin.HomePlugin plugin : plugins) {
            if (plugin == null) continue;
            String name = plugin.getName();
            String version = plugin.getVersion();
            if (name == null) {
                name = "Unknown";
            }
            if (version == null) {
                version = "Unknown";
            }
            String msg = this.translate("PluginCommand.Plugin-info-format").replace("%name%", name).replace("%version%", version);
            player.sendMessage(msg);
        }
        player.sendMessage(this.translate("PluginCommand.Plugin-list-total").replace("%count%", String.valueOf(plugins.size())));
    }

    private String translate(String path) {
        String text = HomePlugin.getLanguageManager().getString(path);
        if (text == null) {
            return path;
        }
        return LanguageManager.translateAlternateColorCodes(text);
    }
}

