/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.commands.home;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.event.OnHomeDeletedEvent;
import fr.fuzeblocks.homeplugin.home.HomeManager;
import fr.fuzeblocks.homeplugin.language.LanguageManager;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class DeleteHomeCommand
implements CommandExecutor {
    private static final String LANG = "Language.";
    private static final String HOME = "Home.";

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        LanguageManager languageManager = HomePlugin.getLanguageManager();
        if (!(sender instanceof Player)) {
            sender.sendMessage(languageManager.getStringWithColor("Language.Only-a-player-can-execute"));
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("homeplugin.command.delhome")) {
            player.sendMessage(languageManager.getStringWithColor("Language.No-permission"));
            return false;
        }
        if (args.length != 1) {
            this.sendUsage(player);
            return false;
        }
        String homeName = args[0];
        HomeManager homeManager = HomePlugin.getHomeManager();
        Location homeLocation = homeManager.getHomeLocation(player, homeName);
        if (homeLocation == null) {
            player.sendMessage(languageManager.getStringWithColor("Home.Home-not-found"));
            return false;
        }
        OnHomeDeletedEvent event = new OnHomeDeletedEvent(player, homeLocation, homeName);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        if (homeManager.deleteHome(player, event.getHomeName())) {
            HomePlugin.getCacheManager().removeHome(player.getUniqueId(), event.getHomeName());
            player.sendMessage(languageManager.getStringWithColor("Home.Home-deleted"));
            return true;
        }
        return false;
    }

    private void sendUsage(Player player) {
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        String title = this.translate("Home.DelHome-management-title");
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("         " + title)));
        player.sendMessage("");
        String usageIcon = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.translate("Home.DelHome-usage-icon")));
        TextComponent viewCmd = new TextComponent("  " + usageIcon + " ");
        viewCmd.setColor(ChatColor.DARK_GRAY);
        TextComponent viewText = new TextComponent("/delhome <home-name>");
        viewText.setColor(ChatColor.YELLOW);
        viewText.setBold(Boolean.valueOf(false));
        viewText.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/delhome <home-name>"));
        String viewHover = this.translate("Home.DelHome-click-suggest");
        viewText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ChatColor.stripColor((String)viewHover)).color(ChatColor.GRAY).create()));
        String viewDesc = this.translate("Home.DelHome-view-description");
        TextComponent viewDescComp = new TextComponent(" - " + ChatColor.stripColor((String)viewDesc));
        viewDescComp.setColor(ChatColor.GRAY);
        viewCmd.addExtra((BaseComponent)viewText);
        viewCmd.addExtra((BaseComponent)viewDescComp);
        player.spigot().sendMessage((BaseComponent)viewCmd);
        player.sendMessage("");
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
    }

    private String translate(String path) {
        return HomePlugin.getLanguageManager().getStringWithColor(path);
    }
}

