/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.commands.home;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.commands.home.SetHomeCommand;
import fr.fuzeblocks.homeplugin.home.HomeManager;
import fr.fuzeblocks.homeplugin.home.HomePermissionManager;
import fr.fuzeblocks.homeplugin.language.LanguageManager;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class RelocateHomeCommand
implements CommandExecutor {
    private static final String HOME = "Home.";
    private static final String LANG = "Language.";

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        LanguageManager languageManager = HomePlugin.getLanguageManager();
        if (!(sender instanceof Player)) {
            sender.sendMessage(languageManager.getStringWithColor("Language.Only-a-player-can-execute"));
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("homeplugin.command.relocatehome")) {
            player.sendMessage(languageManager.getStringWithColor("Language.No-permission"));
            return false;
        }
        if (args.length != 1) {
            this.sendUsage(player);
            return false;
        }
        return this.relocateHome(player, args[0], languageManager);
    }

    private boolean relocateHome(Player player, String homeName, LanguageManager languageManager) {
        HomeManager homeManager = HomePlugin.getHomeManager();
        if (!homeManager.exist(player, homeName)) {
            player.sendMessage(languageManager.getStringWithColor("Home.Home-does-not-exist"));
            return false;
        }
        if (!HomePermissionManager.canSetHome(player)) {
            return false;
        }
        if (HomePlugin.getConfigurationSection().getBoolean("Config.Home.Prevent-Unfair-Location", true) && !SetHomeCommand.isFair(player)) {
            return false;
        }
        Location newLocation = player.getLocation();
        if (newLocation.getWorld() == null) {
            player.sendMessage(languageManager.getStringWithColor("Home.Invalid-world"));
            return false;
        }
        boolean success = homeManager.relocateHome(player, homeName, newLocation);
        if (success) {
            HomePlugin.getCacheManager().relocateHome(player.getUniqueId(), homeName, newLocation);
            player.sendMessage(languageManager.getStringWithColor("Home.Home-relocated").replace("{home}", homeName).replace("%home%", homeName));
        } else {
            player.sendMessage(languageManager.getStringWithColor("Language.Error"));
        }
        return success;
    }

    private void sendUsage(Player player) {
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        String title = this.translate("Home.Relocate-management-title");
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("         " + title)));
        player.sendMessage("");
        String usageIcon = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.translate("Home.Relocate-usage-icon")));
        TextComponent viewCmd = new TextComponent("  " + usageIcon + " ");
        viewCmd.setColor(ChatColor.DARK_GRAY);
        TextComponent viewText = new TextComponent("/relocatehome <existing_home>");
        viewText.setColor(ChatColor.YELLOW);
        viewText.setBold(Boolean.valueOf(false));
        viewText.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/relocatehome <existing_home>"));
        String viewHover = this.translate("Home.Relocate-click-suggest");
        viewText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ChatColor.stripColor((String)viewHover)).color(ChatColor.GRAY).create()));
        String viewDesc = this.translate("Home.Relocate-view-description");
        TextComponent viewDescComp = new TextComponent(" - " + ChatColor.stripColor((String)viewDesc));
        viewDescComp.setColor(ChatColor.GRAY);
        viewCmd.addExtra((BaseComponent)viewText);
        viewCmd.addExtra((BaseComponent)viewDescComp);
        player.spigot().sendMessage((BaseComponent)viewCmd);
        player.sendMessage("");
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
    }

    private String translate(String path) {
        return HomePlugin.getLanguageManager().getStringWithColor(path);
    }
}

