/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.commands.rtp;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.cache.CacheManager;
import fr.fuzeblocks.homeplugin.economy.EconomyManager;
import fr.fuzeblocks.homeplugin.event.OnRTPEvent;
import fr.fuzeblocks.homeplugin.language.LanguageManager;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

public class RTPCommand
implements CommandExecutor {
    private static final String CONFIG_RTP = "Config.RTP.";
    private static final String LANGUAGE = "Language.";
    private static final String MESSAGE_RTP = "Rtp.";
    private static final int COOLDOWN_SECONDS = Math.max(0, HomePlugin.getConfigurationSection().getInt("Config.RTP.Cooldown-Seconds", 300));
    private static final int MAX_RADIUS = Math.max(1, HomePlugin.getConfigurationSection().getInt("Config.RTP.Max-Radius", 200));
    private final LanguageManager languageManager = HomePlugin.getLanguageManager();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        long remaining;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.languageManager.getStringWithColor("Language.Only-a-player-can-execute", "&cSeul un joueur peut ex\u00e9cuter cette commande !"));
            return true;
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        long now = System.currentTimeMillis();
        CacheManager cooldowns = HomePlugin.getCacheManager();
        if (cooldowns.hasRtpRequest(uuid) && (remaining = (cooldowns.getRtpRequest(uuid) + (long)COOLDOWN_SECONDS * 1000L - now) / 1000L) > 0L) {
            player.sendMessage(this.languageManager.getStringWithColor("Rtp.Cooldown-message", "&cVous devez attendre %seconds% secondes avant de refaire un RTP.").replace("%seconds%", String.valueOf(remaining)));
            return true;
        }
        Location randomLocation = this.getRandomSafeLocation(player.getLocation());
        if (randomLocation == null) {
            player.sendMessage(this.languageManager.getStringWithColor("Rtp.Teleport-failed", "&cImpossible de trouver un endroit s\u00fbr pour t\u00e9l\u00e9porter."));
            return true;
        }
        OnRTPEvent event = new OnRTPEvent(player, randomLocation);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getPlayer() == null) {
            player.sendMessage(this.languageManager.getStringWithColor("Rtp.Cancelled", "&cT\u00e9l\u00e9portation al\u00e9atoire annul\u00e9e par une r\u00e8gle ou un autre plugin."));
            return true;
        }
        Location destination = event.getLocation();
        if (!player.isOnline()) {
            return true;
        }
        double price = EconomyManager.getRtpPrice();
        if (price > 0.0 && !EconomyManager.pay(player, price)) {
            return true;
        }
        player.teleport(destination);
        player.sendMessage(this.languageManager.getStringWithColor("Rtp.Teleport-success", "&aT\u00e9l\u00e9portation al\u00e9atoire r\u00e9ussie !"));
        HomePlugin.getCacheManager().addRtpRequest(uuid, System.currentTimeMillis());
        return true;
    }

    @Nullable
    private Location getRandomSafeLocation(Location baseLocation) {
        int MAX_ATTEMPTS = 100;
        World world = baseLocation.getWorld();
        WorldBorder border = world.getWorldBorder();
        double borderCenterX = border.getCenter().getX();
        double borderCenterZ = border.getCenter().getZ();
        double borderRadius = border.getSize() / 2.0;
        for (int attempt = 0; attempt < 100; ++attempt) {
            Location safeLocation;
            int randomZ;
            int[] coords = this.randomIntPositionInCircle(baseLocation, MAX_RADIUS);
            int randomX = coords[0];
            if (!this.isWithinWorldBorder(randomX, randomZ = coords[1], borderCenterX, borderCenterZ, borderRadius) || (safeLocation = this.findSafeLocationAtColumn(world, randomX, randomZ, baseLocation)) == null) continue;
            return safeLocation;
        }
        return null;
    }

    @Nullable
    private Location findSafeLocationAtColumn(World world, int x, int z, Location baseLocation) {
        int minY;
        int maxY;
        try {
            maxY = world.getMaxHeight();
        }
        catch (NoSuchMethodError e) {
            maxY = world.getEnvironment() == World.Environment.NETHER ? 126 : 255;
        }
        try {
            minY = world.getMinHeight();
        }
        catch (NoSuchMethodError e) {
            minY = 0;
        }
        for (int y = maxY; y >= minY; --y) {
            Block blockAtY = world.getBlockAt(x, y, z);
            if (!blockAtY.getType().isSolid() || y + 2 > maxY) continue;
            Block blockAbove1 = world.getBlockAt(x, y + 1, z);
            Block blockAbove2 = world.getBlockAt(x, y + 2, z);
            if (!this.checkIfMaterialIsSafe(blockAtY.getType()) || !this.isAirBlock(blockAbove1.getType()) || !this.isAirBlock(blockAbove2.getType())) continue;
            return new Location(world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5, baseLocation.getYaw(), baseLocation.getPitch());
        }
        return null;
    }

    private boolean isAirBlock(Material material) {
        try {
            return material.isAir();
        }
        catch (NoSuchMethodError e) {
            return material == Material.AIR || material == Material.CAVE_AIR || material == Material.VOID_AIR;
        }
    }

    private int[] randomIntPositionInCircle(Location baseLocation, double radius) {
        double theta = ThreadLocalRandom.current().nextDouble(0.0, Math.PI * 2);
        double r = Math.sqrt(ThreadLocalRandom.current().nextDouble()) * radius;
        double offsetX = r * Math.cos(theta);
        double offsetZ = r * Math.sin(theta);
        int x = (int)Math.round(baseLocation.getX() + offsetX);
        int z = (int)Math.round(baseLocation.getZ() + offsetZ);
        return new int[]{x, z};
    }

    private boolean isWithinWorldBorder(int x, int z, double centerX, double centerZ, double radius) {
        return Math.abs((double)x - centerX) <= radius && Math.abs((double)z - centerZ) <= radius;
    }

    private boolean checkIfMaterialIsSafe(Material material) {
        if (material == Material.LAVA || material == Material.WATER || material == Material.CACTUS || material == Material.FIRE || material == Material.MAGMA_BLOCK || material == Material.SWEET_BERRY_BUSH || material == Material.VOID_AIR || material == Material.CAVE_AIR || material == Material.WITHER_ROSE) {
            return false;
        }
        try {
            if (material == Material.valueOf((String)"SOUL_FIRE") || material == Material.valueOf((String)"POWDER_SNOW") || material == Material.valueOf((String)"POINTED_DRIPSTONE") || material == Material.valueOf((String)"SCULK_SENSOR") || material == Material.valueOf((String)"SCULK_SHRIEKER")) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return true;
    }
}

