/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.commands.tpa;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.event.OnTpaAcceptedEvent;
import fr.fuzeblocks.homeplugin.language.LanguageManager;
import fr.fuzeblocks.homeplugin.tpa.TpaManager;
import fr.fuzeblocks.homeplugin.tpa.TpaRequest;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TPAAcceptCommand
implements CommandExecutor {
    private static final String TPA = "TpaCommand.";
    private static final String LANG = "Language.";

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        LanguageManager languageManager = HomePlugin.getLanguageManager();
        if (!(sender instanceof Player)) {
            sender.sendMessage(languageManager.getStringWithColor("Language.Only-a-player-can-execute"));
            return false;
        }
        Player target = (Player)sender;
        if (!target.hasPermission("homeplugin.command.tpa")) {
            target.sendMessage(languageManager.getStringWithColor("Language.No-permission"));
            return false;
        }
        if (args.length != 1) {
            target.sendMessage(languageManager.getStringWithColor("TpaCommand.Tpa-accept-usage"));
            return false;
        }
        return this.acceptTpaRequest(target, args[0], languageManager);
    }

    private boolean acceptTpaRequest(Player target, String senderName, LanguageManager languageManager) {
        Player senderPlayer = Bukkit.getPlayer((String)senderName);
        if (senderPlayer == null || !senderPlayer.isOnline()) {
            target.sendMessage(languageManager.getStringWithColor("TpaCommand.Tpa-player-not-found").replace("%player%", senderName));
            return false;
        }
        TpaRequest request = TpaManager.getRequest(target.getUniqueId());
        if (request == null) {
            target.sendMessage(languageManager.getStringWithColor("TpaCommand.Tpa-no-pending-request"));
            return false;
        }
        if (!request.sender.getUniqueId().equals(senderPlayer.getUniqueId())) {
            target.sendMessage(languageManager.getStringWithColor("TpaCommand.Tpa-no-request-from-player").replace("%player%", senderPlayer.getName()));
            return false;
        }
        OnTpaAcceptedEvent event = new OnTpaAcceptedEvent(request);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        TpaManager.cancelRequest(target.getUniqueId());
        Location targetLocation = target.getLocation();
        if (targetLocation.getWorld() == null) {
            target.sendMessage(languageManager.getStringWithColor("Language.Invalid-world"));
            return false;
        }
        if (!senderPlayer.isOnline()) {
            target.sendMessage(languageManager.getStringWithColor("TpaCommand.Tpa-player-offline").replace("%player%", senderPlayer.getName()));
            return false;
        }
        senderPlayer.teleport(targetLocation);
        senderPlayer.sendMessage(languageManager.getStringWithColor("TpaCommand.Tpa-accepted-by-target").replace("%player%", target.getName()));
        target.sendMessage(languageManager.getStringWithColor("TpaCommand.Tpa-accepted").replace("%player%", senderPlayer.getName()));
        return true;
    }
}

