/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.commands.tpa;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.economy.EconomyManager;
import fr.fuzeblocks.homeplugin.event.OnTpaCreatedEvent;
import fr.fuzeblocks.homeplugin.language.LanguageManager;
import fr.fuzeblocks.homeplugin.tpa.TpaManager;
import fr.fuzeblocks.homeplugin.tpa.TpaRequest;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class TPACommand
implements CommandExecutor {
    private static final String TPA = "TpaCommand.";
    private static final String LANG = "Language.";

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        LanguageManager languageManager = HomePlugin.getLanguageManager();
        if (!(sender instanceof Player)) {
            sender.sendMessage(languageManager.getStringWithColor("Language.Only-a-player-can-execute"));
            return false;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("homeplugin.command.tpa")) {
            player.sendMessage(languageManager.getStringWithColor("Language.No-permission"));
            return false;
        }
        if (args.length != 1) {
            player.sendMessage(languageManager.getStringWithColor("TpaCommand.Tpa-usage-message"));
            return false;
        }
        return this.sendTpaRequest(player, args[0], languageManager);
    }

    private boolean sendTpaRequest(Player player, String targetName, LanguageManager languageManager) {
        TpaRequest existingRequest;
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null || !target.isOnline()) {
            player.sendMessage(languageManager.getStringWithColor("TpaCommand.Tpa-player-not-found").replace("%player%", targetName));
            return false;
        }
        if (target.equals(player)) {
            player.sendMessage(languageManager.getStringWithColor("TpaCommand.Tpa-cannot-request-yourself"));
            return false;
        }
        if (TpaManager.hasRequest(target.getUniqueId()) && (existingRequest = TpaManager.getRequest(target.getUniqueId())) != null && existingRequest.sender.equals(player)) {
            player.sendMessage(languageManager.getStringWithColor("TpaCommand.Tpa-already-sent").replace("%player%", target.getName()));
            return false;
        }
        TpaRequest request = new TpaRequest(player, target, null);
        OnTpaCreatedEvent event = new OnTpaCreatedEvent(request);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        double price = EconomyManager.getTpaRequestPrice();
        if (price > 0.0 && !EconomyManager.pay(player, price)) {
            player.sendMessage(languageManager.getStringWithColor("Language.Not-Enough-Money"));
            return false;
        }
        boolean success = TpaManager.sendTpaRequest(player, target);
        if (!success) {
            player.sendMessage(languageManager.getStringWithColor("TpaCommand.Tpa-send-failed"));
            return false;
        }
        return true;
    }
}

