/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.database;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.database.DatabaseCredentials;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DatabaseConnection {
    private static DatabaseCredentials credentials;
    private static Connection connection;

    public DatabaseConnection(DatabaseCredentials credentials) {
        DatabaseConnection.credentials = credentials;
        DatabaseConnection.connect();
    }

    public static void connect() {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            connection = DriverManager.getConnection(credentials.toURI(), credentials.getUser(), credentials.getPass());
            Logger.getLogger("HomePlugin").warning("Successfully connected to DB.");
        }
        catch (ClassNotFoundException | SQLException e) {
            System.err.println("Error when connecting to DB ! Exiting...");
            Bukkit.getPluginManager().disablePlugin((Plugin)HomePlugin.getPlugin(HomePlugin.class));
        }
    }

    public static Connection getConnection() {
        if (connection != null) {
            try {
                if (!connection.isClosed()) {
                    return connection;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        DatabaseConnection.connect();
        return connection;
    }

    public void close() {
        if (connection != null) {
            try {
                if (!connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

