/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.economy;

import fr.fuzeblocks.homeplugin.HomePlugin;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class EconomyManager {
    private static Economy economy;
    private static ConfigurationSection config;
    private static final String ECONOMY_KEY = "Config.Economy.";
    private static boolean enabled;

    public static void setup(HomePlugin plugin) {
        economy = plugin.getEconomy();
        config = plugin.getConfig();
        enabled = config != null && config.getBoolean("Config.Economy.UseEconomy", true);
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static double getCost(String key, double defaultValue) {
        return config != null ? config.getDouble(ECONOMY_KEY + key, defaultValue) : defaultValue;
    }

    public static double getHomeCreationCost() {
        return EconomyManager.getCost("Home-Creation-Price", 0.0);
    }

    public static double getHomeTeleportPrice() {
        return EconomyManager.getCost("Home-Teleport-Price", 0.0);
    }

    public static double getTpaRequestPrice() {
        return EconomyManager.getCost("Tpa-Request-Price", 0.0);
    }

    public static double getRtpPrice() {
        return EconomyManager.getCost("RTP-Price", 0.0);
    }

    public static boolean pay(Player player, double amount) {
        if (!enabled) {
            return true;
        }
        if (amount <= 0.0) {
            return true;
        }
        if (economy == null) {
            player.sendMessage("\u00a7cAucun syst\u00e8me \u00e9conomique d\u00e9tect\u00e9.");
            return false;
        }
        EconomyResponse response = economy.withdrawPlayer((OfflinePlayer)player, amount);
        String messageKey = response.transactionSuccess() ? "Economy.Payment-successful" : "Economy.Payment-failed";
        String defaultMessage = response.transactionSuccess() ? "&aVous avez \u00e9t\u00e9 d\u00e9bit\u00e9 de %amount% pour cette action." : "&cLe paiement a \u00e9chou\u00e9. Veuillez r\u00e9essayer plus tard.";
        player.sendMessage(HomePlugin.getLanguageManager().getStringWithColor(messageKey, defaultMessage).replace("%amount%", String.valueOf(amount)));
        return response.transactionSuccess();
    }

    static {
        enabled = true;
    }
}

