/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.gui;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.economy.EconomyManager;
import fr.fuzeblocks.homeplugin.home.HomeManager;
import fr.fuzeblocks.homeplugin.task.TeleportationManager;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.invui.item.ItemProvider;
import xyz.xenondevs.invui.item.builder.ItemBuilder;
import xyz.xenondevs.invui.item.impl.AbstractItem;

public class HomeItem
extends AbstractItem {
    private final String homeName;
    private final String HOME = "Home.";
    private boolean deleted = false;

    public HomeItem(String homeName) {
        this.homeName = homeName;
    }

    @Override
    public void handleClick(@NotNull ClickType clickType, @NotNull Player player, @NotNull InventoryClickEvent inventoryClickEvent) {
        HomeManager homeManager = HomePlugin.getHomeManager();
        if (homeManager.exist(player, this.homeName)) {
            if (clickType.isRightClick()) {
                player.sendMessage(HomePlugin.getLanguageManager().getStringWithColor("Home.Home-deleted-with-name").replace("{homeName}", this.homeName));
                homeManager.deleteHome(player, this.homeName);
                this.deleted = true;
                this.notifyWindows();
            } else {
                player.closeInventory();
                double cost = EconomyManager.getHomeTeleportPrice();
                if (cost > 0.0 && !EconomyManager.pay(player, cost)) {
                    player.sendMessage(HomePlugin.getLanguageManager().getStringWithColor("Language.Not-Enough-Money"));
                } else {
                    TeleportationManager.teleportPlayerToHome(player, this.homeName);
                }
            }
        } else {
            player.sendMessage(HomePlugin.getLanguageManager().getStringWithColor("Home.Home-does-not-exist"));
            player.closeInventory();
        }
    }

    @Override
    public ItemProvider getItemProvider() {
        if (this.deleted) {
            return new ItemBuilder(Material.AIR);
        }
        String displayNameTemplate = HomePlugin.getLanguageManager().getStringWithColor("Home.Home-item-displayname");
        String displayName = displayNameTemplate.replace("{homeName}", this.homeName);
        String loreTeleport = HomePlugin.getLanguageManager().getStringWithColor("Home.Home-item-lore-teleport");
        String loreDelete = HomePlugin.getLanguageManager().getStringWithColor("Home.Home-item-lore-delete");
        return (ItemProvider)((ItemBuilder)new ItemBuilder(this.getRandomBedColor()).setDisplayName(displayName)).setLegacyLore(Arrays.asList(loreTeleport, loreDelete));
    }

    private Material getRandomBedColor() {
        Material[] bedColors = new Material[]{Material.RED_BED, Material.GREEN_BED, Material.BLUE_BED, Material.YELLOW_BED, Material.PINK_BED, Material.BLACK_BED, Material.WHITE_BED, Material.ORANGE_BED, Material.CYAN_BED};
        return bedColors[(int)(Math.random() * (double)bedColors.length)];
    }
}

