/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.placeholder;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.language.LanguageManager;
import java.util.List;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class HomePluginExpansion
extends PlaceholderExpansion {
    private final HomePlugin homePlugin;

    public HomePluginExpansion(HomePlugin homePlugin) {
        this.homePlugin = homePlugin;
    }

    @NotNull
    public String getIdentifier() {
        return "homeplugin";
    }

    @NotNull
    public String getAuthor() {
        return "fuzeblocks";
    }

    @NotNull
    public String getVersion() {
        return this.homePlugin.getDescription().getVersion();
    }

    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String params) {
        String name;
        String lowerParams;
        if (!offlinePlayer.isOnline()) {
            return this.translate("Messages.Player-is-not-online", "Joueur hors-ligne");
        }
        Player player = offlinePlayer.getPlayer();
        if (player == null) {
            return "";
        }
        switch (lowerParams = params.toLowerCase()) {
            case "homes": {
                List<String> homeNames = HomePlugin.getHomeManager().getHomesName(player);
                if (homeNames != null && !homeNames.isEmpty()) {
                    return String.join((CharSequence)", ", homeNames);
                }
                return this.translate("Messages.no-homes", "Aucun home");
            }
            case "homes_numbers": {
                return String.valueOf(HomePlugin.getHomeManager().getHomeNumber(player));
            }
            case "has_homes": {
                return HomePlugin.getHomeManager().getHomeNumber(player) > 0 ? "true" : "false";
            }
        }
        if (lowerParams.startsWith("home_location_")) {
            name = params.substring("home_location_".length());
            Location loc = HomePlugin.getHomeManager().getHomeLocation(player, name);
            if (loc != null) {
                String format = this.translate("Messages.home-location-format", "X: %.1f, Y: %.1f, Z: %.1f, Monde: %s");
                return String.format(format, loc.getX(), loc.getY(), loc.getZ(), loc.getWorld().getName());
            }
            return this.translate("Messages.Unknown", "Inconnu");
        }
        if (lowerParams.startsWith("home_exists_")) {
            name = params.substring("home_exists_".length());
            boolean exists = HomePlugin.getHomeManager().exist(player, name);
            return exists ? "true" : "false";
        }
        if (lowerParams.startsWith("home_world_")) {
            name = params.substring("home_world_".length());
            Location loc = HomePlugin.getHomeManager().getHomeLocation(player, name);
            if (loc != null) {
                return loc.getWorld().getName();
            }
            return this.translate("Messages.Unknown", "Inconnu");
        }
        if (lowerParams.startsWith("home_coordinates_")) {
            name = params.substring("home_coordinates_".length());
            Location loc = HomePlugin.getHomeManager().getHomeLocation(player, name);
            if (loc != null) {
                return String.format("%.1f %.1f %.1f", loc.getX(), loc.getY(), loc.getZ());
            }
            return this.translate("Messages.Unknown", "Inconnu");
        }
        return null;
    }

    private String translate(String path, String defaultValue) {
        String value = HomePlugin.getLanguageManager().getString(path);
        if (value == null || value.isEmpty()) {
            value = defaultValue;
        }
        return LanguageManager.translateAlternateColorCodes(value);
    }
}

