/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.spawn;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.spawn.Spawn;
import fr.fuzeblocks.homeplugin.spawn.sql.SpawnSQLManager;
import fr.fuzeblocks.homeplugin.spawn.yml.SpawnYMLManager;
import fr.fuzeblocks.homeplugin.status.StatusManager;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class SpawnManager
implements Spawn {
    private static SpawnManager instance = null;
    private final SpawnYMLManager spawnYMLManager = HomePlugin.getSpawnYMLManager();
    private final SpawnSQLManager spawnSQLManager = HomePlugin.getSpawnSQLManager();

    private SpawnManager() {
    }

    public static SpawnManager getInstance() {
        if (instance == null) {
            instance = new SpawnManager();
        }
        return instance;
    }

    @Override
    public boolean setSpawn(Location location) {
        if (this.isYAML()) {
            return this.spawnYMLManager.setSpawn(location);
        }
        return this.spawnSQLManager.setSpawn(location);
    }

    @Override
    public Location getSpawn(World world) {
        if (this.isYAML()) {
            return this.spawnYMLManager.getSpawn(world);
        }
        return this.spawnSQLManager.getSpawn(world);
    }

    @Override
    public boolean hasSpawn(World world) {
        if (this.isYAML()) {
            return this.spawnYMLManager.hasSpawn(world);
        }
        return this.spawnSQLManager.hasSpawn(world);
    }

    @Override
    public boolean removeSpawn(World world) {
        if (this.isYAML()) {
            return this.spawnYMLManager.removeSpawn(world);
        }
        return this.spawnSQLManager.removeSpawn(world);
    }

    @Override
    public boolean isStatus(Player player) {
        return StatusManager.getPlayerStatus(player);
    }
}

