/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.tpa;

import fr.fuzeblocks.homeplugin.tpa.TpaRequestStore;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import redis.clients.jedis.JedisPooled;

public class RedisTpaRequestStore
implements TpaRequestStore {
    private static final String FIELD_TPA_TARGET = "tpa_target";
    private final JedisPooled jedis;

    public RedisTpaRequestStore(JedisPooled jedis) {
        this.jedis = jedis;
    }

    @Override
    public void addTpaRequest(UUID sender, UUID target) {
        this.jedis.hset(sender.toString(), FIELD_TPA_TARGET, target.toString());
    }

    @Override
    public boolean hasTpaRequest(UUID sender, UUID target) {
        String stored = this.jedis.hget(sender.toString(), FIELD_TPA_TARGET);
        return target.toString().equals(stored);
    }

    @Override
    public void removeTpaRequest(UUID sender, UUID target) {
        String stored = this.jedis.hget(sender.toString(), FIELD_TPA_TARGET);
        if (target.toString().equals(stored)) {
            this.jedis.hdel(sender.toString(), FIELD_TPA_TARGET);
        }
    }

    @Override
    public UUID getTargetWithSender(UUID sender) {
        String targetUuid = this.jedis.hget(sender.toString(), FIELD_TPA_TARGET);
        if (targetUuid == null) {
            return null;
        }
        try {
            return UUID.fromString(targetUuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public boolean hasIncomingTpa(UUID target) {
        Set<String> keys = this.jedis.keys("*");
        for (String key : keys) {
            String stored = this.jedis.hget(key, FIELD_TPA_TARGET);
            if (!target.toString().equals(stored)) continue;
            return true;
        }
        return false;
    }

    @Override
    public UUID getSenderForTarget(UUID target) {
        Set<String> keys = this.jedis.keys("*");
        for (String key : keys) {
            String stored = this.jedis.hget(key, FIELD_TPA_TARGET);
            if (!target.toString().equals(stored)) continue;
            try {
                return UUID.fromString(key);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return null;
    }

    @Override
    public UUID getTpaTarget(UUID senderId) {
        String targetUuid = this.jedis.hget(senderId.toString(), FIELD_TPA_TARGET);
        if (targetUuid == null) {
            return null;
        }
        try {
            return UUID.fromString(targetUuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public Set<UUID> getAllTpaSenders() {
        Set<String> keys = this.jedis.keys("*");
        return keys.stream().map(key -> {
            try {
                return UUID.fromString(key);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).filter(uuid -> uuid != null).collect(Collectors.toSet());
    }
}

