/*
 * Decompiled with CFR 0.152.
 */
package fr.fuzeblocks.homeplugin.tpa;

import fr.fuzeblocks.homeplugin.HomePlugin;
import fr.fuzeblocks.homeplugin.cache.CacheManager;
import fr.fuzeblocks.homeplugin.language.LanguageManager;
import fr.fuzeblocks.homeplugin.tpa.TpaRequest;
import fr.fuzeblocks.libs.net.kyori.adventure.text.Component;
import fr.fuzeblocks.libs.net.kyori.adventure.text.TextComponent;
import fr.fuzeblocks.libs.net.kyori.adventure.text.event.ClickEvent;
import fr.fuzeblocks.libs.net.kyori.adventure.text.event.HoverEvent;
import fr.fuzeblocks.libs.net.kyori.adventure.text.format.NamedTextColor;
import fr.fuzeblocks.libs.net.kyori.adventure.text.format.StyleSetter;
import fr.fuzeblocks.libs.net.kyori.adventure.text.format.TextColor;
import fr.fuzeblocks.libs.net.kyori.adventure.text.format.TextDecoration;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TpaManager {
    private static final HashMap<UUID, BukkitRunnable> timeoutTasks = new HashMap();
    private static final int TIMEOUT_SECONDS = HomePlugin.getConfigurationSection().getInt("Config.Tpa.Tpa-duration", 30);
    private static final String TPA = "TpaCommand.";

    public static boolean sendTpaRequest(Player sender, Player target) {
        if (sender == null || target == null || !sender.isOnline() || !target.isOnline()) {
            return false;
        }
        CacheManager cacheManager = CacheManager.getInstance();
        if (cacheManager == null) {
            return false;
        }
        UUID senderId = sender.getUniqueId();
        UUID targetId = target.getUniqueId();
        LanguageManager languageManager = HomePlugin.getLanguageManager();
        if (cacheManager.getTargetWithSender(senderId) != null) {
            sender.sendMessage(languageManager.getStringWithColor("TpaCommand.Tpa-request-exists"));
            return false;
        }
        sender.sendMessage(languageManager.getStringWithColor("TpaCommand.Tpa-request-sent").replace("%player%", target.getName()));
        TpaManager.sendRequestNotification(sender, target, languageManager);
        cacheManager.addTpaRequest(senderId, targetId);
        TpaManager.startTimeoutTask(sender, target, senderId, targetId, cacheManager, languageManager);
        return true;
    }

    private static void sendRequestNotification(Player sender, Player target, LanguageManager languageManager) {
        String receivedBase = languageManager.getStringWithColor("TpaCommand.Tpa-request-received").replace("%player%", sender.getName());
        target.sendMessage(receivedBase);
        TextComponent prompt = Component.text("  ", (TextColor)NamedTextColor.DARK_GRAY);
        StyleSetter accept = ((TextComponent)Component.text("[\u1d00\u1d04\u1d04\u1d07\u1d18\u1d1b]", (TextColor)NamedTextColor.GREEN, TextDecoration.BOLD).clickEvent(ClickEvent.runCommand("/tpaccept " + sender.getName()))).hoverEvent(HoverEvent.showText(Component.text("Click to accept teleport request", (TextColor)NamedTextColor.GRAY)));
        TextComponent separator = Component.text("  ", (TextColor)NamedTextColor.DARK_GRAY);
        StyleSetter deny = ((TextComponent)Component.text("[\u1d05\u1d07\u0274\u028f]", (TextColor)NamedTextColor.RED, TextDecoration.BOLD).clickEvent(ClickEvent.runCommand("/tpdeny " + sender.getName()))).hoverEvent(HoverEvent.showText(Component.text("Click to deny teleport request", (TextColor)NamedTextColor.GRAY)));
        HomePlugin.getAdventure().player(target).sendMessage(prompt.append((Component)accept).append(separator).append((Component)deny));
    }

    private static void startTimeoutTask(final Player sender, final Player target, final UUID senderId, final UUID targetId, final CacheManager cacheManager, final LanguageManager languageManager) {
        BukkitRunnable existingTask = timeoutTasks.get(senderId);
        if (existingTask != null) {
            existingTask.cancel();
        }
        BukkitRunnable timeoutTask = new BukkitRunnable(){

            public void run() {
                if (cacheManager.hasTpaRequest(senderId, targetId)) {
                    cacheManager.removeTpaRequest(senderId, targetId);
                    if (sender.isOnline()) {
                        sender.sendMessage(languageManager.getStringWithColor("TpaCommand.Tpa-request-expired"));
                    }
                    if (target.isOnline()) {
                        target.sendMessage(languageManager.getStringWithColor("TpaCommand.Tpa-request-expired-target").replace("%player%", sender.getName()));
                    }
                    timeoutTasks.remove(senderId);
                }
            }
        };
        timeoutTask.runTaskLater((Plugin)HomePlugin.getPlugin(HomePlugin.class), 20L * (long)TIMEOUT_SECONDS);
        timeoutTasks.put(senderId, timeoutTask);
    }

    public static void cancelRequest(UUID senderId) {
        BukkitRunnable task;
        UUID targetId;
        if (senderId == null) {
            return;
        }
        CacheManager cacheManager = CacheManager.getInstance();
        if (cacheManager != null && (targetId = cacheManager.getTargetWithSender(senderId)) != null) {
            cacheManager.removeTpaRequest(senderId, targetId);
        }
        if ((task = timeoutTasks.remove(senderId)) != null) {
            task.cancel();
        }
    }

    public static TpaRequest getRequest(UUID targetId) {
        if (targetId == null) {
            return null;
        }
        CacheManager cacheManager = CacheManager.getInstance();
        if (cacheManager == null) {
            return null;
        }
        UUID senderId = cacheManager.getSenderForTarget(targetId);
        if (senderId == null) {
            return null;
        }
        Player sender = Bukkit.getPlayer((UUID)senderId);
        Player target = Bukkit.getPlayer((UUID)targetId);
        if (sender != null && target != null && sender.isOnline() && target.isOnline()) {
            return new TpaRequest(sender, target, timeoutTasks.get(senderId));
        }
        return null;
    }

    public static boolean hasRequest(UUID targetId) {
        if (targetId == null) {
            return false;
        }
        CacheManager cacheManager = CacheManager.getInstance();
        if (cacheManager == null) {
            return false;
        }
        return cacheManager.getSenderForTarget(targetId) != null;
    }
}

