/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.inventoryaccess.component.i18n;

import fr.fuzeblocks.libs.net.kyori.adventure.text.BuildableComponent;
import fr.fuzeblocks.libs.net.kyori.adventure.text.Component;
import fr.fuzeblocks.libs.net.kyori.adventure.text.ComponentBuilder;
import fr.fuzeblocks.libs.net.kyori.adventure.text.ComponentLike;
import fr.fuzeblocks.libs.net.kyori.adventure.text.TranslatableComponent;
import fr.fuzeblocks.libs.net.kyori.adventure.util.Buildable;
import java.util.List;
import xyz.xenondevs.inventoryaccess.component.i18n.ComponentLocalizer;
import xyz.xenondevs.inventoryaccess.component.i18n.Languages;

public class AdventureComponentLocalizer
extends ComponentLocalizer<Component> {
    private static final AdventureComponentLocalizer INSTANCE = new AdventureComponentLocalizer();

    private AdventureComponentLocalizer() {
        super(Component::text);
    }

    public static AdventureComponentLocalizer getInstance() {
        return INSTANCE;
    }

    @Override
    public Component localize(String lang, Component component) {
        if (!(component instanceof BuildableComponent)) {
            throw new IllegalStateException("Component is not a BuildableComponent");
        }
        return this.localize(lang, (BuildableComponent)component);
    }

    @Override
    private <C extends BuildableComponent<C, B>, B extends ComponentBuilder<C, B>> BuildableComponent<?, ?> localize(String lang, BuildableComponent<C, B> component) {
        Buildable.Builder builder = component instanceof TranslatableComponent ? this.localizeTranslatable(lang, (TranslatableComponent)component).toBuilder() : component.toBuilder();
        builder.mapChildrenDeep(child -> {
            if (child instanceof TranslatableComponent) {
                return this.localizeTranslatable(lang, (TranslatableComponent)child);
            }
            return child;
        });
        return builder.build();
    }

    private BuildableComponent<?, ?> localizeTranslatable(String lang, TranslatableComponent component) {
        String formatString = Languages.getInstance().getFormatString(lang, component.key());
        if (formatString == null) {
            return component;
        }
        List<Component> children = this.decomposeFormatString(lang, formatString, component, component.args());
        return (BuildableComponent)Component.textOfChildren((ComponentLike[])children.toArray(ComponentLike[]::new)).style(component.style());
    }
}

