/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.inventoryaccess.r5;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.server.v1_16_R1.AdvancementDataPlayer;
import net.minecraft.server.v1_16_R1.AdvancementDataWorld;
import net.minecraft.server.v1_16_R1.EntityPlayer;
import net.minecraft.server.v1_16_R1.MapIcon;
import net.minecraft.server.v1_16_R1.Packet;
import net.minecraft.server.v1_16_R1.PacketPlayOutMap;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R1.CraftServer;
import org.bukkit.craftbukkit.v1_16_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.inventoryaccess.abstraction.util.PlayerUtils;
import xyz.xenondevs.inventoryaccess.map.MapIcon;
import xyz.xenondevs.inventoryaccess.map.MapPatch;
import xyz.xenondevs.inventoryaccess.r5.InventoryUtilsImpl;
import xyz.xenondevs.inventoryaccess.util.ReflectionUtils;

class PlayerUtilsImpl
implements PlayerUtils {
    private static final Method REGISTER_LISTENERS_METHOD = ReflectionUtils.getMethod(AdvancementDataPlayer.class, true, "b", AdvancementDataWorld.class);

    PlayerUtilsImpl() {
    }

    @Override
    public void stopAdvancementListening(@NotNull Player player) {
        this.stopAdvancementListening(((CraftPlayer)player).getHandle());
    }

    @Override
    public void stopAdvancementListening(@NotNull Object player) {
        ((EntityPlayer)player).getAdvancementData().a();
    }

    @Override
    public void startAdvancementListening(@NotNull Player player) {
        this.startAdvancementListening(((CraftPlayer)player).getHandle());
    }

    @Override
    public void startAdvancementListening(@NotNull Object player) {
        AdvancementDataPlayer advancements = ((EntityPlayer)player).getAdvancementData();
        AdvancementDataWorld manager = ((CraftServer)Bukkit.getServer()).getServer().getAdvancementData();
        ReflectionUtils.invokeMethod(REGISTER_LISTENERS_METHOD, advancements, manager);
    }

    @Override
    public void sendMapUpdate(@NotNull Player player, int mapId, byte scale, boolean locked, @Nullable MapPatch mapPatch, @Nullable List<MapIcon> icons) {
        ArrayList decorations = icons != null ? (List)icons.stream().map(this::toMapDecoration).collect(Collectors.toCollection(ArrayList::new)) : new ArrayList();
        int width = 0;
        int height = 0;
        int startX = 0;
        int startY = 0;
        byte[] colors = new byte[]{};
        if (mapPatch != null) {
            width = mapPatch.getWidth();
            height = mapPatch.getHeight();
            startX = mapPatch.getStartX();
            startY = mapPatch.getStartY();
            colors = mapPatch.getColors();
        }
        PacketPlayOutMap packet = new PacketPlayOutMap(mapId, scale, !decorations.isEmpty(), locked, decorations, colors, startX, startY, width, height);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
    }

    private net.minecraft.server.v1_16_R1.MapIcon toMapDecoration(MapIcon icon) {
        return new net.minecraft.server.v1_16_R1.MapIcon(MapIcon.Type.a((byte)icon.getType().getId()), icon.getX(), icon.getY(), icon.getRot(), icon.getComponent() != null ? InventoryUtilsImpl.createNMSComponent(icon.getComponent()) : null);
    }
}

