/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.inventoryaccess.r6;

import net.minecraft.server.v1_16_R2.Container;
import net.minecraft.server.v1_16_R2.Containers;
import net.minecraft.server.v1_16_R2.EntityHuman;
import net.minecraft.server.v1_16_R2.EntityPlayer;
import net.minecraft.server.v1_16_R2.IChatBaseComponent;
import net.minecraft.server.v1_16_R2.ICrafting;
import net.minecraft.server.v1_16_R2.IInventory;
import net.minecraft.server.v1_16_R2.ITileInventory;
import net.minecraft.server.v1_16_R2.Packet;
import net.minecraft.server.v1_16_R2.PacketPlayOutOpenWindow;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_16_R2.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.inventoryaccess.abstraction.util.InventoryUtils;
import xyz.xenondevs.inventoryaccess.component.ComponentWrapper;

class InventoryUtilsImpl
implements InventoryUtils {
    InventoryUtilsImpl() {
    }

    public static IChatBaseComponent createNMSComponent(ComponentWrapper component) {
        return IChatBaseComponent.ChatSerializer.a((String)component.serializeToJson());
    }

    public static int getActiveWindowId(EntityPlayer player) {
        Container container = player.activeContainer;
        return container == null ? -1 : container.windowId;
    }

    @Override
    public void openCustomInventory(@NotNull Player player, @NotNull Inventory inventory) {
        this.openCustomInventory(player, inventory, null);
    }

    @Override
    public void openCustomInventory(@NotNull Player player, @NotNull Inventory inventory, @Nullable ComponentWrapper title) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        Containers windowType = CraftContainer.getNotchInventoryType((Inventory)inventory);
        if (entityPlayer.playerConnection != null) {
            CraftContainer container = new CraftContainer(inventory, (EntityHuman)entityPlayer, entityPlayer.nextContainerCounter());
            if ((container = CraftEventFactory.callInventoryOpenEvent((EntityPlayer)entityPlayer, (Container)container)) != null) {
                IInventory iinventory = ((CraftInventory)inventory).getInventory();
                IChatBaseComponent titleComponent = title == null ? (iinventory instanceof ITileInventory ? ((ITileInventory)iinventory).getScoreboardDisplayName() : CraftChatMessage.fromString((String)container.getBukkitView().getTitle())[0]) : InventoryUtilsImpl.createNMSComponent(title);
                entityPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(container.windowId, windowType, titleComponent));
                entityPlayer.activeContainer = container;
                entityPlayer.activeContainer.addSlotListener((ICrafting)entityPlayer);
            }
        }
    }

    @Override
    public void updateOpenInventoryTitle(@NotNull Player player, @NotNull ComponentWrapper title) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        Container container = entityPlayer.activeContainer;
        entityPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(container.windowId, container.getType(), InventoryUtilsImpl.createNMSComponent(title)));
        entityPlayer.updateInventory(container);
    }

    @Override
    @Nullable
    public ItemStack getItemStackFromView(@NotNull InventoryView view, int slot) {
        return view.getItem(slot);
    }
}

