/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.gui;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.invui.animation.Animation;
import xyz.xenondevs.invui.gui.NormalGuiImpl;
import xyz.xenondevs.invui.gui.SlotElement;
import xyz.xenondevs.invui.gui.structure.Marker;
import xyz.xenondevs.invui.gui.structure.Structure;
import xyz.xenondevs.invui.inventory.Inventory;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.invui.item.ItemProvider;
import xyz.xenondevs.invui.window.Window;

public interface Gui {
    @NotNull
    public static Builder.Normal normal() {
        return new NormalGuiImpl.Builder();
    }

    @NotNull
    public static Gui normal(@NotNull @NotNull Consumer<@NotNull Builder.Normal> consumer) {
        Builder.Normal builder = Gui.normal();
        consumer.accept(builder);
        return builder.build();
    }

    @NotNull
    public static Gui empty(int width, int height) {
        return new NormalGuiImpl(width, height);
    }

    @NotNull
    public static Gui of(@NotNull Structure structure) {
        return new NormalGuiImpl(structure);
    }

    public int getSize();

    public int getWidth();

    public int getHeight();

    public void setSlotElement(int var1, int var2, @Nullable SlotElement var3);

    public void setSlotElement(int var1, @Nullable SlotElement var2);

    public void addSlotElements(SlotElement ... var1);

    @Nullable
    public SlotElement getSlotElement(int var1, int var2);

    @Nullable
    public SlotElement getSlotElement(int var1);

    public boolean hasSlotElement(int var1, int var2);

    public boolean hasSlotElement(int var1);

    public @Nullable SlotElement @NotNull [] getSlotElements();

    public void setItem(int var1, int var2, @Nullable Item var3);

    public void setItem(int var1, @Nullable Item var2);

    public void addItems(Item ... var1);

    @Nullable
    public Item getItem(int var1, int var2);

    @Nullable
    public Item getItem(int var1);

    @Nullable
    public ItemProvider getBackground();

    public void setBackground(@Nullable ItemProvider var1);

    public void remove(int var1, int var2);

    public void remove(int var1);

    public void applyStructure(@NotNull Structure var1);

    @NotNull
    public @NotNull List<@NotNull Window> findAllWindows();

    @NotNull
    public @NotNull Set<@NotNull Player> findAllCurrentViewers();

    public void closeForAllViewers();

    public void playAnimation(@NotNull Animation var1, @Nullable Predicate<@NotNull SlotElement> var2);

    public void cancelAnimation();

    public void setFrozen(boolean var1);

    public boolean isFrozen();

    public void setIgnoreObscuredInventorySlots(boolean var1);

    public boolean isIgnoreObscuredInventorySlots();

    public void fill(int var1, int var2, @Nullable Item var3, boolean var4);

    public void fill(@Nullable Item var1, boolean var2);

    public void fillRow(int var1, @Nullable Item var2, boolean var3);

    public void fillColumn(int var1, @Nullable Item var2, boolean var3);

    public void fillBorders(@Nullable Item var1, boolean var2);

    public void fillRectangle(int var1, int var2, int var3, int var4, @Nullable Item var5, boolean var6);

    public void fillRectangle(int var1, int var2, @NotNull Gui var3, boolean var4);

    public void fillRectangle(int var1, int var2, int var3, @NotNull Inventory var4, boolean var5);

    public void fillRectangle(int var1, int var2, int var3, @NotNull Inventory var4, @Nullable ItemProvider var5, boolean var6);

    public static interface Builder<G extends Gui, S extends Builder<G, S>>
    extends Cloneable {
        @Contract(value="_ -> this")
        @NotNull
        public S setStructure(@NotNull Structure var1);

        @Contract(value="_ -> this")
        @NotNull
        public S setStructure(String ... var1);

        @Contract(value="_, _, _, -> this")
        @NotNull
        public S setStructure(int var1, int var2, @NotNull String var3);

        @Contract(value="_, _ -> this")
        @NotNull
        public S addIngredient(char var1, @NotNull ItemStack var2);

        @Contract(value="_, _ -> this")
        @NotNull
        public S addIngredient(char var1, @NotNull ItemProvider var2);

        @Contract(value="_, _ -> this")
        @NotNull
        public S addIngredient(char var1, @NotNull Item var2);

        @Contract(value="_, _ -> this")
        @NotNull
        public S addIngredient(char var1, @NotNull Inventory var2);

        @Contract(value="_, _, _ -> this")
        @NotNull
        public S addIngredient(char var1, @NotNull Inventory var2, @Nullable ItemProvider var3);

        @Contract(value="_, _ -> this")
        @NotNull
        public S addIngredient(char var1, @NotNull SlotElement var2);

        @Contract(value="_, _ -> this")
        @NotNull
        public S addIngredient(char var1, @NotNull Marker var2);

        @Contract(value="_, _ -> this")
        @NotNull
        public S addIngredient(char var1, @NotNull Supplier<? extends Item> var2);

        @Contract(value="_, _ -> this")
        @NotNull
        public S addIngredientElementSupplier(char var1, @NotNull Supplier<? extends SlotElement> var2);

        @Contract(value="_ -> this")
        @NotNull
        public S setBackground(@NotNull ItemProvider var1);

        @Contract(value="_ -> this")
        @NotNull
        public S setBackground(@NotNull ItemStack var1);

        @Contract(value="_ -> this")
        @NotNull
        public S setFrozen(boolean var1);

        @Contract(value="_ -> this")
        @NotNull
        public S setIgnoreObscuredInventorySlots(boolean var1);

        @Contract(value="_ -> this")
        @NotNull
        public S addModifier(@NotNull @NotNull Consumer<@NotNull G> var1);

        @Contract(value="_ -> this")
        @NotNull
        public S setModifiers(@NotNull @NotNull List<@NotNull Consumer<@NotNull G>> var1);

        @Contract(value="-> new")
        @NotNull
        public G build();

        @Contract(value="-> new")
        @NotNull
        public S clone();

        public static interface Normal
        extends Builder<Gui, Normal> {
        }
    }
}

