/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.gui;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.invui.gui.AbstractScrollGui;
import xyz.xenondevs.invui.gui.ScrollGui;
import xyz.xenondevs.invui.gui.SlotElement;
import xyz.xenondevs.invui.gui.structure.Structure;
import xyz.xenondevs.invui.item.Item;

final class ScrollItemsGuiImpl
extends AbstractScrollGui<Item> {
    public ScrollItemsGuiImpl(int width, int height, @Nullable List<@NotNull Item> items, int ... contentListSlots) {
        super(width, height, false, contentListSlots);
        this.setContent(items);
    }

    public ScrollItemsGuiImpl(@Nullable List<@NotNull Item> items, @NotNull Structure structure) {
        super(structure.getWidth(), structure.getHeight(), false, structure);
        this.setContent(items);
    }

    @Override
    public void bake() {
        ArrayList<SlotElement.ItemSlotElement> elements = new ArrayList<SlotElement.ItemSlotElement>(this.content.size());
        for (Item item : this.content) {
            elements.add(new SlotElement.ItemSlotElement(item));
        }
        this.elements = elements;
        this.update();
    }

    public static final class Builder
    extends AbstractScrollGui.AbstractBuilder<Item> {
        @Override
        @NotNull
        public ScrollGui<Item> build() {
            if (this.structure == null) {
                throw new IllegalStateException("Structure is not defined.");
            }
            ScrollItemsGuiImpl gui = new ScrollItemsGuiImpl(this.content, this.structure);
            this.applyModifiers(gui);
            return gui;
        }
    }
}

