/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.gui;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import xyz.xenondevs.invui.gui.AbstractGui;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.inventory.Inventory;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.invui.item.ItemProvider;

public interface SlotElement {
    public ItemStack getItemStack(String var1);

    default public ItemStack getItemStack(Player viewer, String lang) {
        return this.getItemStack(lang);
    }

    public SlotElement getHoldingElement();

    public static class LinkedSlotElement
    implements SlotElement {
        private final Gui gui;
        private final int slot;

        public LinkedSlotElement(Gui gui, int slot) {
            if (!(gui instanceof AbstractGui)) {
                throw new IllegalArgumentException("Illegal Gui implementation");
            }
            this.gui = gui;
            this.slot = slot;
        }

        public Gui getGui() {
            return this.gui;
        }

        public int getSlotIndex() {
            return this.slot;
        }

        @Override
        public SlotElement getHoldingElement() {
            SlotElement below;
            LinkedSlotElement element = this;
            while ((below = element.getGui().getSlotElement(element.getSlotIndex())) instanceof LinkedSlotElement) {
                element = (LinkedSlotElement)below;
            }
            return below;
        }

        public List<Gui> getGuiList() {
            ArrayList<Gui> guis = new ArrayList<Gui>();
            LinkedSlotElement element = this;
            while (true) {
                guis.add(element.getGui());
                SlotElement below = element.getGui().getSlotElement(element.getSlotIndex());
                if (!(below instanceof LinkedSlotElement)) break;
                element = (LinkedSlotElement)below;
            }
            return guis;
        }

        @Override
        public ItemStack getItemStack(String lang) {
            SlotElement holdingElement = this.getHoldingElement();
            return holdingElement != null ? holdingElement.getItemStack(lang) : null;
        }

        @Override
        public ItemStack getItemStack(Player viewer, String lang) {
            SlotElement holdingElement = this.getHoldingElement();
            return holdingElement != null ? holdingElement.getItemStack(viewer, lang) : null;
        }
    }

    public static class InventorySlotElement
    implements SlotElement {
        private final Inventory inventory;
        private final int slot;
        private final ItemProvider background;

        public InventorySlotElement(Inventory inventory, int slot) {
            this.inventory = inventory;
            this.slot = slot;
            this.background = null;
        }

        public InventorySlotElement(Inventory inventory, int slot, ItemProvider background) {
            this.inventory = inventory;
            this.slot = slot;
            this.background = background;
        }

        public Inventory getInventory() {
            return this.inventory;
        }

        public int getSlot() {
            return this.slot;
        }

        public ItemProvider getBackground() {
            return this.background;
        }

        @Override
        public ItemStack getItemStack(String lang) {
            ItemStack itemStack = this.inventory.getUnsafeItem(this.slot);
            if (itemStack == null && this.background != null) {
                itemStack = this.background.get(lang);
            }
            return itemStack;
        }

        @Override
        public SlotElement getHoldingElement() {
            return this;
        }
    }

    public static class ItemSlotElement
    implements SlotElement {
        private final Item item;

        public ItemSlotElement(Item item) {
            this.item = item;
        }

        public Item getItem() {
            return this.item;
        }

        @Override
        public ItemStack getItemStack(String lang) {
            return this.item.getItemProvider().get(lang);
        }

        @Override
        public ItemStack getItemStack(Player viewer, String lang) {
            return this.item.getItemProvider(viewer).get(lang);
        }

        @Override
        public SlotElement getHoldingElement() {
            return this;
        }
    }
}

