/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.inventory;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.invui.InvUI;
import xyz.xenondevs.invui.inventory.VirtualInventory;
import xyz.xenondevs.invui.inventory.event.ItemPostUpdateEvent;
import xyz.xenondevs.invui.inventory.event.ItemPreUpdateEvent;
import xyz.xenondevs.invui.inventory.event.UpdateReason;
import xyz.xenondevs.invui.util.ArrayUtils;
import xyz.xenondevs.invui.util.InventoryUtils;
import xyz.xenondevs.invui.util.ItemUtils;
import xyz.xenondevs.invui.window.AbstractWindow;
import xyz.xenondevs.invui.window.Window;

public abstract class Inventory {
    private Set<AbstractWindow> windows;
    private Consumer<ItemPreUpdateEvent> preUpdateHandler;
    private Consumer<ItemPostUpdateEvent> postUpdateHandler;
    private int guiPriority = 0;

    public abstract int getSize();

    public abstract int @NotNull [] getMaxStackSizes();

    public abstract int getMaxSlotStackSize(int var1);

    public abstract @Nullable ItemStack @NotNull [] getItems();

    public abstract @Nullable ItemStack @NotNull [] getUnsafeItems();

    @Nullable
    public abstract ItemStack getItem(int var1);

    @Nullable
    public abstract ItemStack getUnsafeItem(int var1);

    protected abstract void setCloneBackingItem(int var1, @Nullable ItemStack var2);

    protected abstract void setDirectBackingItem(int var1, @Nullable ItemStack var2);

    @NotNull
    public @NotNull Set<@NotNull Window> getWindows() {
        if (this.windows == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.windows);
    }

    public void addWindow(AbstractWindow window) {
        if (this.windows == null) {
            this.windows = new HashSet<AbstractWindow>();
        }
        this.windows.add(window);
    }

    public void removeWindow(AbstractWindow window) {
        if (this.windows == null) {
            return;
        }
        this.windows.remove(window);
    }

    public void notifyWindows() {
        if (this.windows == null) {
            return;
        }
        this.windows.forEach(window -> window.handleInventoryUpdate(this));
    }

    public @Nullable Consumer<@NotNull ItemPreUpdateEvent> getPreUpdateHandler() {
        return this.preUpdateHandler;
    }

    public void setPreUpdateHandler(@Nullable Consumer<@NotNull ItemPreUpdateEvent> preUpdateHandler) {
        this.preUpdateHandler = preUpdateHandler;
    }

    public @Nullable Consumer<@NotNull ItemPostUpdateEvent> getPostUpdateHandler() {
        return this.postUpdateHandler;
    }

    public void setPostUpdateHandler(@Nullable Consumer<@NotNull ItemPostUpdateEvent> inventoryUpdatedHandler) {
        this.postUpdateHandler = inventoryUpdatedHandler;
    }

    public boolean hasEventHandlers() {
        return this.preUpdateHandler != null || this.postUpdateHandler != null;
    }

    private boolean shouldCallEvents(@Nullable UpdateReason updateReason) {
        return this.hasEventHandlers() && updateReason != UpdateReason.SUPPRESSED;
    }

    public ItemPreUpdateEvent callPreUpdateEvent(@Nullable UpdateReason updateReason, int slot, @Nullable ItemStack previousItemStack, @Nullable ItemStack newItemStack) {
        if (updateReason == UpdateReason.SUPPRESSED) {
            throw new IllegalArgumentException("Cannot call ItemUpdateEvent with UpdateReason.SUPPRESSED");
        }
        ItemPreUpdateEvent event = new ItemPreUpdateEvent(this, slot, updateReason, previousItemStack, newItemStack);
        if (this.preUpdateHandler != null) {
            try {
                this.preUpdateHandler.accept(event);
            }
            catch (Throwable t) {
                InvUI.getInstance().getLogger().log(Level.SEVERE, "An exception occurred while handling an inventory event", t);
            }
        }
        return event;
    }

    public void callPostUpdateEvent(@Nullable UpdateReason updateReason, int slot, @Nullable ItemStack previousItemStack, @Nullable ItemStack newItemStack) {
        if (updateReason == UpdateReason.SUPPRESSED) {
            throw new IllegalArgumentException("Cannot call InventoryUpdatedEvent with UpdateReason.SUPPRESSED");
        }
        ItemPostUpdateEvent event = new ItemPostUpdateEvent(this, slot, updateReason, previousItemStack, newItemStack);
        if (this.postUpdateHandler != null) {
            try {
                this.postUpdateHandler.accept(event);
            }
            catch (Throwable t) {
                InvUI.getInstance().getLogger().log(Level.SEVERE, "An exception occurred while handling an inventory event", t);
            }
        }
    }

    public int getGuiPriority() {
        return this.guiPriority;
    }

    public void setGuiPriority(int guiPriority) {
        this.guiPriority = guiPriority;
    }

    public int getMaxStackSize(int slot) {
        ItemStack currentItem = this.getUnsafeItem(slot);
        int slotMaxStackSize = this.getMaxSlotStackSize(slot);
        if (currentItem != null) {
            return Math.min(InventoryUtils.stackSizeProvider.getMaxStackSize(currentItem), slotMaxStackSize);
        }
        return slotMaxStackSize;
    }

    public int getMaxStackSize(int slot, int alternative) {
        ItemStack currentItem = this.getUnsafeItem(slot);
        int slotMaxStackSize = this.getMaxSlotStackSize(slot);
        return Math.min(currentItem != null ? InventoryUtils.stackSizeProvider.getMaxStackSize(currentItem) : alternative, slotMaxStackSize);
    }

    public int getMaxStackSize(int slot, @Nullable ItemStack alternativeFrom) {
        int itemMaxStackSize = alternativeFrom == null ? 64 : InventoryUtils.stackSizeProvider.getMaxStackSize(alternativeFrom);
        return this.getMaxStackSize(slot, itemMaxStackSize);
    }

    public int getMaxSlotStackSize(int slot, int alternative) {
        return Math.min(alternative, this.getMaxSlotStackSize(slot));
    }

    public int getMaxSlotStackSize(int slot, @Nullable ItemStack alternativeFrom) {
        int itemMaxStackSize = alternativeFrom == null ? 64 : InventoryUtils.stackSizeProvider.getMaxStackSize(alternativeFrom);
        return this.getMaxSlotStackSize(slot, itemMaxStackSize);
    }

    public boolean isSynced(int slot, ItemStack assumedStack) {
        ItemStack actualStack = this.getUnsafeItem(slot);
        return Objects.equals(actualStack, assumedStack);
    }

    public boolean isFull() {
        ItemStack[] items = this.getUnsafeItems();
        for (int slot = 0; slot < items.length; ++slot) {
            ItemStack item = items[slot];
            if (item != null && item.getAmount() >= this.getMaxStackSize(slot)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (ItemStack item : this.getUnsafeItems()) {
            if (item == null) continue;
            return false;
        }
        return true;
    }

    public boolean hasEmptySlot() {
        for (ItemStack item : this.getUnsafeItems()) {
            if (item != null) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Predicate<ItemStack> predicate) {
        for (ItemStack item : this.getUnsafeItems()) {
            if (item == null || !predicate.test(item.clone())) continue;
            return true;
        }
        return false;
    }

    public boolean containsSimilar(ItemStack itemStack) {
        for (ItemStack item : this.getUnsafeItems()) {
            if (item == null || !item.isSimilar(itemStack)) continue;
            return true;
        }
        return false;
    }

    public int count(Predicate<ItemStack> predicate) {
        int count = 0;
        for (ItemStack item : this.getUnsafeItems()) {
            if (item == null || !predicate.test(item.clone())) continue;
            ++count;
        }
        return count;
    }

    public int countSimilar(ItemStack itemStack) {
        int count = 0;
        for (ItemStack item : this.getUnsafeItems()) {
            if (item == null || !item.isSimilar(itemStack)) continue;
            ++count;
        }
        return count;
    }

    public boolean hasItem(int slot) {
        return this.getUnsafeItem(slot) != null;
    }

    public int getItemAmount(int slot) {
        ItemStack currentStack = this.getUnsafeItem(slot);
        return currentStack != null ? currentStack.getAmount() : 0;
    }

    public void setItemSilently(int slot, @Nullable ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            itemStack = null;
        }
        this.setCloneBackingItem(slot, itemStack);
        this.notifyWindows();
    }

    public boolean forceSetItem(@Nullable UpdateReason updateReason, int slot, @Nullable ItemStack itemStack) {
        if (!this.shouldCallEvents(updateReason)) {
            this.setItemSilently(slot, itemStack);
            return true;
        }
        ItemStack previousStack = this.getItem(slot);
        ItemPreUpdateEvent event = this.callPreUpdateEvent(updateReason, slot, previousStack, itemStack != null ? itemStack.clone() : null);
        if (!event.isCancelled()) {
            ItemStack newStack = event.getNewItem();
            this.setItemSilently(slot, newStack);
            this.callPostUpdateEvent(updateReason, slot, previousStack, newStack);
            return true;
        }
        return false;
    }

    public boolean setItem(@Nullable UpdateReason updateReason, int slot, @Nullable ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            return this.forceSetItem(updateReason, slot, null);
        }
        int maxStackSize = this.getMaxSlotStackSize(slot, itemStack);
        if (itemStack.getAmount() > maxStackSize) {
            return false;
        }
        return this.forceSetItem(updateReason, slot, itemStack);
    }

    public boolean modifyItem(@Nullable UpdateReason updateReason, int slot, @NotNull Consumer<@Nullable ItemStack> modifier) {
        ItemStack itemStack = this.getItem(slot);
        modifier.accept(itemStack);
        return this.setItem(updateReason, slot, itemStack);
    }

    public boolean replaceItem(@Nullable UpdateReason updateReason, int slot, @NotNull Function<@Nullable ItemStack, @Nullable ItemStack> function) {
        ItemStack currentStack = this.getItem(slot);
        ItemStack newStack = function.apply(currentStack);
        return this.setItem(updateReason, slot, newStack);
    }

    public int putItem(@Nullable UpdateReason updateReason, int slot, @NotNull ItemStack itemStack) {
        int maxStackSize;
        int currentAmount;
        if (ItemUtils.isEmpty(itemStack)) {
            return 0;
        }
        ItemStack currentStack = this.getUnsafeItem(slot);
        if ((currentStack == null || currentStack.isSimilar(itemStack)) && (currentAmount = currentStack == null ? 0 : currentStack.getAmount()) < (maxStackSize = this.getMaxStackSize(slot, itemStack))) {
            int additionalAmount = itemStack.getAmount();
            int newAmount = Math.min(currentAmount + additionalAmount, maxStackSize);
            ItemStack newItemStack = itemStack.clone();
            newItemStack.setAmount(newAmount);
            if (this.shouldCallEvents(updateReason)) {
                ItemStack currentStackC = currentStack != null ? currentStack.clone() : null;
                ItemPreUpdateEvent event = this.callPreUpdateEvent(updateReason, slot, currentStackC, newItemStack);
                if (!event.isCancelled()) {
                    newItemStack = event.getNewItem();
                    this.setCloneBackingItem(slot, newItemStack);
                    this.notifyWindows();
                    int newAmountEvent = newItemStack != null ? newItemStack.getAmount() : 0;
                    int remaining = itemStack.getAmount() - (newAmountEvent - currentAmount);
                    this.callPostUpdateEvent(updateReason, slot, currentStackC, newItemStack);
                    return remaining;
                }
            } else {
                this.setDirectBackingItem(slot, newItemStack);
                this.notifyWindows();
                return additionalAmount - (newAmount - currentAmount);
            }
        }
        return itemStack.getAmount();
    }

    public int setItemAmount(@Nullable UpdateReason updateReason, int slot, int amount) {
        ItemStack newItemStack;
        ItemStack currentStack = this.getUnsafeItem(slot);
        if (currentStack == null) {
            throw new IllegalStateException("There is no ItemStack on that slot");
        }
        int maxStackSize = this.getMaxStackSize(slot);
        if (amount > 0) {
            newItemStack = currentStack.clone();
            newItemStack.setAmount(Math.min(amount, maxStackSize));
        } else {
            newItemStack = null;
        }
        if (this.shouldCallEvents(updateReason)) {
            ItemStack currentStackC = currentStack != null ? currentStack.clone() : null;
            ItemPreUpdateEvent event = this.callPreUpdateEvent(updateReason, slot, currentStackC, newItemStack);
            if (!event.isCancelled()) {
                newItemStack = event.getNewItem();
                this.setCloneBackingItem(slot, newItemStack);
                this.notifyWindows();
                int actualAmount = newItemStack != null ? newItemStack.getAmount() : 0;
                this.callPostUpdateEvent(updateReason, slot, currentStackC, newItemStack);
                return actualAmount;
            }
        } else {
            this.setDirectBackingItem(slot, newItemStack);
            this.notifyWindows();
            return amount;
        }
        return currentStack.getAmount();
    }

    public int addItemAmount(@Nullable UpdateReason updateReason, int slot, int amount) {
        ItemStack currentStack = this.getUnsafeItem(slot);
        if (currentStack == null) {
            return 0;
        }
        int currentAmount = currentStack.getAmount();
        return this.setItemAmount(updateReason, slot, currentAmount + amount) - currentAmount;
    }

    public int addItem(@Nullable UpdateReason updateReason, @NotNull ItemStack itemStack) {
        int originalAmount;
        if (ItemUtils.isEmpty(itemStack)) {
            return 0;
        }
        ItemStack[] items = this.getUnsafeItems();
        int amountLeft = originalAmount = itemStack.getAmount();
        amountLeft = this.addToPartialSlots(updateReason, itemStack, amountLeft, items);
        if (originalAmount != (amountLeft = this.addToEmptySlots(updateReason, itemStack, amountLeft, items))) {
            this.notifyWindows();
        }
        return amountLeft;
    }

    private int addToPartialSlots(@Nullable UpdateReason updateReason, @NotNull ItemStack itemStack, int amountLeft, @Nullable ItemStack @NotNull [] items) {
        for (int slot = 0; slot < items.length && amountLeft > 0; ++slot) {
            ItemStack currentStack = items[slot];
            if (currentStack == null) continue;
            int maxStackSize = this.getMaxSlotStackSize(slot, itemStack);
            if (currentStack.getAmount() >= maxStackSize || !itemStack.isSimilar(currentStack)) continue;
            ItemStack newStack = itemStack.clone();
            newStack.setAmount(Math.min(currentStack.getAmount() + amountLeft, maxStackSize));
            if (this.shouldCallEvents(updateReason)) {
                ItemPreUpdateEvent event = this.callPreUpdateEvent(updateReason, slot, currentStack.clone(), newStack);
                if (event.isCancelled()) continue;
                newStack = event.getNewItem();
                this.setCloneBackingItem(slot, newStack);
                this.callPostUpdateEvent(updateReason, slot, currentStack.clone(), newStack);
                int newStackAmount = newStack != null ? newStack.getAmount() : 0;
                amountLeft -= newStackAmount - currentStack.getAmount();
                continue;
            }
            this.setDirectBackingItem(slot, newStack);
            amountLeft -= newStack.getAmount() - currentStack.getAmount();
        }
        return amountLeft;
    }

    private int addToEmptySlots(@Nullable UpdateReason updateReason, @NotNull ItemStack itemStack, int amountLeft, @Nullable ItemStack @NotNull [] items) {
        for (int slot = 0; slot < items.length && amountLeft > 0; ++slot) {
            if (items[slot] != null) continue;
            ItemStack newStack = itemStack.clone();
            newStack.setAmount(Math.min(amountLeft, this.getMaxSlotStackSize(slot, itemStack)));
            if (this.shouldCallEvents(updateReason)) {
                ItemPreUpdateEvent event = this.callPreUpdateEvent(updateReason, slot, null, newStack);
                if (event.isCancelled()) continue;
                newStack = event.getNewItem();
                this.setCloneBackingItem(slot, newStack);
                this.callPostUpdateEvent(updateReason, slot, null, newStack);
                int newStackAmount = newStack != null ? newStack.getAmount() : 0;
                amountLeft -= newStackAmount;
                continue;
            }
            this.setDirectBackingItem(slot, newStack);
            amountLeft -= newStack.getAmount();
        }
        return amountLeft;
    }

    public int[] simulateAdd(@NotNull ItemStack first, ItemStack ... rest) {
        if (rest.length == 0) {
            return new int[]{this.simulateSingleAdd(first)};
        }
        ItemStack[] allStacks = ArrayUtils.concat(first, rest);
        return this.simulateMultiAdd(Arrays.asList(allStacks));
    }

    public int[] simulateAdd(@NotNull @NotNull List<@NotNull ItemStack> itemStacks) {
        if (itemStacks.isEmpty()) {
            return new int[0];
        }
        if (itemStacks.size() == 1) {
            return new int[]{this.simulateSingleAdd(itemStacks.get(0))};
        }
        return this.simulateMultiAdd(itemStacks);
    }

    public boolean canHold(@NotNull ItemStack first, ItemStack ... rest) {
        if (rest.length == 0) {
            return this.simulateSingleAdd(first) == 0;
        }
        ItemStack[] allStacks = ArrayUtils.concat(first, rest);
        return Arrays.stream(this.simulateMultiAdd(Arrays.asList(allStacks))).allMatch(i -> i == 0);
    }

    public boolean canHold(@NotNull @NotNull List<@NotNull ItemStack> itemStacks) {
        if (itemStacks.isEmpty()) {
            return true;
        }
        if (itemStacks.size() == 1) {
            return this.simulateSingleAdd(itemStacks.get(0)) == 0;
        }
        return Arrays.stream(this.simulateMultiAdd(itemStacks)).allMatch(i -> i == 0);
    }

    public int simulateSingleAdd(@NotNull ItemStack itemStack) {
        int slot;
        if (ItemUtils.isEmpty(itemStack)) {
            return 0;
        }
        ItemStack[] items = this.getUnsafeItems();
        int amountLeft = itemStack.getAmount();
        for (slot = 0; slot < items.length && amountLeft != 0; ++slot) {
            ItemStack currentStack = items[slot];
            if (currentStack == null) continue;
            int maxStackSize = this.getMaxSlotStackSize(slot, itemStack);
            if (currentStack.getAmount() >= maxStackSize || !itemStack.isSimilar(currentStack)) continue;
            amountLeft = Math.max(0, amountLeft - (maxStackSize - currentStack.getAmount()));
        }
        for (slot = 0; slot < items.length && amountLeft != 0; ++slot) {
            if (items[slot] != null) continue;
            int maxStackSize = this.getMaxStackSize(slot, itemStack);
            amountLeft -= Math.min(amountLeft, maxStackSize);
        }
        return amountLeft;
    }

    public int[] simulateMultiAdd(@NotNull @NotNull List<@NotNull ItemStack> itemStacks) {
        VirtualInventory copy = new VirtualInventory(null, this.getSize(), this.getItems(), (int[])this.getMaxStackSizes().clone());
        int[] result = new int[itemStacks.size()];
        for (int index = 0; index != itemStacks.size(); ++index) {
            result[index] = copy.addItem(UpdateReason.SUPPRESSED, itemStacks.get(index));
        }
        return result;
    }

    public int collectSimilar(@Nullable UpdateReason updateReason, @NotNull ItemStack itemStack) {
        return this.collectSimilar(updateReason, itemStack, itemStack.getAmount());
    }

    public int collectSimilar(@Nullable UpdateReason updateReason, @NotNull ItemStack template, int baseAmount) {
        int amount = baseAmount;
        int maxStackSize = InventoryUtils.stackSizeProvider.getMaxStackSize(template);
        if (amount < maxStackSize) {
            ItemStack currentStack;
            int slot;
            ItemStack[] items = this.getUnsafeItems();
            for (slot = 0; slot < items.length; ++slot) {
                currentStack = items[slot];
                if (currentStack == null || currentStack.getAmount() >= maxStackSize || !template.isSimilar(currentStack) || (amount += this.takeFrom(updateReason, slot, maxStackSize - amount)) != maxStackSize) continue;
                return amount;
            }
            for (slot = 0; slot < items.length; ++slot) {
                currentStack = items[slot];
                if (currentStack == null || currentStack.getAmount() <= maxStackSize || !template.isSimilar(currentStack) || (amount += this.takeFrom(updateReason, slot, maxStackSize - amount)) != maxStackSize) continue;
                return amount;
            }
        }
        return amount;
    }

    public int removeIf(@Nullable UpdateReason updateReason, @NotNull @NotNull Predicate<@NotNull ItemStack> predicate) {
        ItemStack[] items = this.getUnsafeItems();
        int removed = 0;
        for (int slot = 0; slot < items.length; ++slot) {
            ItemStack item = items[slot];
            if (item == null || !predicate.test(item.clone()) || !this.setItem(updateReason, slot, null)) continue;
            removed += item.getAmount();
        }
        return removed;
    }

    public int removeFirst(@Nullable UpdateReason updateReason, int amount, @NotNull @NotNull Predicate<@NotNull ItemStack> predicate) {
        ItemStack[] items = this.getUnsafeItems();
        int leftOver = amount;
        for (int slot = 0; slot < items.length; ++slot) {
            ItemStack item = items[slot];
            if (item == null || !predicate.test(item.clone()) || (leftOver -= this.takeFrom(updateReason, slot, leftOver)) != 0) continue;
            return 0;
        }
        return amount - leftOver;
    }

    public int removeSimilar(@Nullable UpdateReason updateReason, @NotNull ItemStack itemStack) {
        ItemStack[] items = this.getUnsafeItems();
        int removed = 0;
        for (int slot = 0; slot < items.length; ++slot) {
            ItemStack item = items[slot];
            if (item == null || !item.isSimilar(itemStack) || !this.setItem(updateReason, slot, null)) continue;
            removed += item.getAmount();
        }
        return removed;
    }

    public int removeFirstSimilar(@Nullable UpdateReason updateReason, int amount, @NotNull ItemStack itemStack) {
        ItemStack[] items = this.getUnsafeItems();
        int leftOver = amount;
        for (int slot = 0; slot < items.length; ++slot) {
            ItemStack item = items[slot];
            if (item == null || !item.isSimilar(itemStack) || (leftOver -= this.takeFrom(updateReason, slot, leftOver)) != 0) continue;
            return 0;
        }
        return amount - leftOver;
    }

    private int takeFrom(@Nullable UpdateReason updateReason, int slot, int maxTake) {
        ItemStack newItemStack;
        ItemStack currentItemStack = this.getUnsafeItem(slot);
        int amount = currentItemStack.getAmount();
        int take = Math.min(amount, maxTake);
        if (take != amount) {
            newItemStack = currentItemStack.clone();
            newItemStack.setAmount(amount - take);
        } else {
            newItemStack = null;
        }
        if (this.shouldCallEvents(updateReason)) {
            ItemStack currentItemStackC = currentItemStack.clone();
            ItemPreUpdateEvent event = this.callPreUpdateEvent(updateReason, slot, currentItemStackC, newItemStack);
            if (!event.isCancelled()) {
                newItemStack = event.getNewItem();
                this.setCloneBackingItem(slot, newItemStack);
                this.notifyWindows();
                int amountTaken = currentItemStack.getAmount() - (newItemStack == null ? 0 : newItemStack.getAmount());
                this.callPostUpdateEvent(updateReason, slot, currentItemStackC, newItemStack);
                return amountTaken;
            }
        } else {
            this.setDirectBackingItem(slot, newItemStack);
            this.notifyWindows();
            return take;
        }
        return 0;
    }
}

