/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.item.builder;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.inventoryaccess.util.ReflectionRegistry;
import xyz.xenondevs.inventoryaccess.util.ReflectionUtils;
import xyz.xenondevs.invui.item.builder.AbstractItemBuilder;
import xyz.xenondevs.invui.util.MojangApiUtils;

public final class SkullBuilder
extends AbstractItemBuilder<SkullBuilder> {
    private GameProfile gameProfile;

    @Deprecated
    public SkullBuilder(@NotNull UUID uuid) throws MojangApiUtils.MojangApiException, IOException {
        this(HeadTexture.of(uuid));
    }

    @Deprecated
    public SkullBuilder(@NotNull String username) throws MojangApiUtils.MojangApiException, IOException {
        this(HeadTexture.of(username));
    }

    public SkullBuilder(@NotNull HeadTexture headTexture) {
        super(Material.PLAYER_HEAD);
        this.setGameProfile(headTexture);
    }

    private void setGameProfile(@NotNull HeadTexture texture) {
        this.gameProfile = new GameProfile(UUID.randomUUID(), "InvUI");
        PropertyMap propertyMap = this.gameProfile.getProperties();
        propertyMap.put((Object)"textures", (Object)new Property("textures", texture.getTextureValue()));
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public ItemStack get(@Nullable String lang) {
        ItemStack item = super.get(lang);
        ItemMeta meta = item.getItemMeta();
        if (this.gameProfile != null) {
            if (ReflectionRegistry.CB_CRAFT_META_SKULL_SET_RESOLVABLE_PROFILE_METHOD != null && ReflectionRegistry.RESOLVABLE_PROFILE_FROM_GAME_PROFILE_CONSTRUCTOR != null) {
                Object resolvableProfile = ReflectionUtils.construct(ReflectionRegistry.RESOLVABLE_PROFILE_FROM_GAME_PROFILE_CONSTRUCTOR, this.gameProfile);
                ReflectionUtils.invokeMethod(ReflectionRegistry.CB_CRAFT_META_SKULL_SET_RESOLVABLE_PROFILE_METHOD, meta, resolvableProfile);
            } else if (ReflectionRegistry.CB_CRAFT_META_SKULL_SET_PROFILE_METHOD != null) {
                ReflectionUtils.invokeMethod(ReflectionRegistry.CB_CRAFT_META_SKULL_SET_PROFILE_METHOD, meta, this.gameProfile);
            } else {
                ReflectionUtils.setFieldValue(ReflectionRegistry.CB_CRAFT_META_SKULL_PROFILE_FIELD, meta, this.gameProfile);
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public SkullBuilder setMaterial(@NotNull Material material) {
        return this;
    }

    @Override
    @Contract(value="-> new", pure=true)
    @NotNull
    public SkullBuilder clone() {
        return (SkullBuilder)super.clone();
    }

    public static class HeadTexture
    implements Serializable {
        private static final Cache<UUID, String> textureCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build();
        private static final Cache<String, UUID> uuidCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build();
        private final String textureValue;

        public HeadTexture(@NotNull String textureValue) {
            this.textureValue = textureValue;
        }

        @Deprecated
        @NotNull
        public static HeadTexture of(@NotNull OfflinePlayer offlinePlayer) throws MojangApiUtils.MojangApiException, IOException {
            return HeadTexture.of(offlinePlayer.getUniqueId());
        }

        @Deprecated
        @NotNull
        public static HeadTexture of(@NotNull String playerName) throws MojangApiUtils.MojangApiException, IOException {
            if (Bukkit.getServer().getOnlineMode()) {
                return HeadTexture.of(Bukkit.getOfflinePlayer((String)playerName).getUniqueId());
            }
            try {
                return HeadTexture.of((UUID)uuidCache.get((Object)playerName, () -> MojangApiUtils.getCurrentUuid(playerName)));
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof MojangApiUtils.MojangApiException) {
                    throw (MojangApiUtils.MojangApiException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new RuntimeException(cause);
            }
        }

        @Deprecated
        @NotNull
        public static HeadTexture of(@NotNull UUID uuid) throws MojangApiUtils.MojangApiException, IOException {
            try {
                return new HeadTexture((String)textureCache.get((Object)uuid, () -> MojangApiUtils.getSkinData(uuid, false)[0]));
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof MojangApiUtils.MojangApiException) {
                    throw (MojangApiUtils.MojangApiException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new RuntimeException(cause);
            }
        }

        @Deprecated
        public static void invalidateCache() {
            uuidCache.invalidateAll();
            textureCache.invalidateAll();
        }

        @NotNull
        public String getTextureValue() {
            return this.textureValue;
        }
    }
}

