/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.item.impl;

import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.scheduler.BukkitTask;
import xyz.xenondevs.invui.InvUI;
import xyz.xenondevs.invui.item.ItemProvider;
import xyz.xenondevs.invui.item.impl.SuppliedItem;
import xyz.xenondevs.invui.window.AbstractWindow;

public class AutoUpdateItem
extends SuppliedItem {
    private final int period;
    private BukkitTask task;

    public AutoUpdateItem(int period, Supplier<? extends ItemProvider> builderSupplier) {
        super(builderSupplier, null);
        this.period = period;
    }

    public void start() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = Bukkit.getScheduler().runTaskTimer(InvUI.getInstance().getPlugin(), this::notifyWindows, 0L, (long)this.period);
    }

    public void cancel() {
        this.task.cancel();
        this.task = null;
    }

    @Override
    public void addWindow(AbstractWindow window) {
        super.addWindow(window);
        if (this.task == null) {
            this.start();
        }
    }

    @Override
    public void removeWindow(AbstractWindow window) {
        super.removeWindow(window);
        if (this.getWindows().isEmpty() && this.task != null) {
            this.cancel();
        }
    }
}

