/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.item.impl;

import java.util.function.BiConsumer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.invui.item.ItemProvider;
import xyz.xenondevs.invui.item.impl.AbstractItem;

public class CycleItem
extends AbstractItem {
    private final ItemProvider[] states;
    private int state;

    public CycleItem(ItemProvider ... states) {
        this(0, states);
    }

    public CycleItem(int startState, ItemProvider ... states) {
        this.states = states;
        this.state = startState;
    }

    public static CycleItem withStateChangeHandler(BiConsumer<Player, Integer> stateChangeHandler, ItemProvider ... states) {
        return CycleItem.withStateChangeHandler(stateChangeHandler, 0, states);
    }

    public static CycleItem withStateChangeHandler(final BiConsumer<Player, Integer> stateChangeHandler, int startState, ItemProvider ... states) {
        return new CycleItem(startState, states){

            @Override
            protected void handleStateChange(@Nullable Player player, int state) {
                stateChangeHandler.accept(player, state);
            }
        };
    }

    @Override
    public ItemProvider getItemProvider() {
        return this.states[this.state];
    }

    @Override
    public void handleClick(@NotNull ClickType clickType, @NotNull Player player, @NotNull InventoryClickEvent event) {
        if (clickType.isLeftClick()) {
            this.cycle(player, true);
        } else if (clickType.isRightClick()) {
            this.cycle(player, false);
        }
    }

    public void cycle(boolean forward) {
        this.cycle(null, forward);
    }

    private void cycle(@Nullable Player player, boolean forward) {
        if (forward) {
            if (++this.state == this.states.length) {
                this.state = 0;
            }
        } else if (--this.state < 0) {
            this.state = this.states.length - 1;
        }
        this.handleStateChange(player, this.state);
        this.notifyWindows();
    }

    protected void handleStateChange(@Nullable Player player, int state) {
    }

    public int getState() {
        return this.state;
    }
}

