/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.window;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.inventoryaccess.InventoryAccess;
import xyz.xenondevs.inventoryaccess.abstraction.inventory.CartographyInventory;
import xyz.xenondevs.inventoryaccess.component.ComponentWrapper;
import xyz.xenondevs.inventoryaccess.map.MapIcon;
import xyz.xenondevs.inventoryaccess.map.MapPatch;
import xyz.xenondevs.invui.gui.AbstractGui;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.item.ItemWrapper;
import xyz.xenondevs.invui.item.impl.SimpleItem;
import xyz.xenondevs.invui.util.MathUtils;
import xyz.xenondevs.invui.window.AbstractSingleWindow;
import xyz.xenondevs.invui.window.CartographyWindow;

final class CartographySingleWindowImpl
extends AbstractSingleWindow
implements CartographyWindow {
    private final CartographyInventory cartographyInventory;
    private int mapId;

    public CartographySingleWindowImpl(@NotNull Player player, @Nullable ComponentWrapper title, @NotNull AbstractGui gui, boolean closeable) {
        super(player, title, CartographySingleWindowImpl.createWrappingGui(gui), null, closeable);
        if (gui.getWidth() != 2 || gui.getHeight() != 1) {
            throw new IllegalArgumentException("Gui has to be 2x1");
        }
        this.cartographyInventory = InventoryAccess.createCartographyInventory(player, title != null ? title.localized(player) : null);
        this.inventory = this.cartographyInventory.getBukkitInventory();
        this.resetMap();
    }

    private static AbstractGui createWrappingGui(Gui upperGui) {
        if (upperGui.getWidth() != 2 || upperGui.getHeight() != 1) {
            throw new IllegalArgumentException("Gui has to be 2x1");
        }
        Gui wrapperGui = Gui.empty(3, 1);
        wrapperGui.fillRectangle(1, 0, upperGui, true);
        return (AbstractGui)wrapperGui;
    }

    @Override
    public void updateMap(@Nullable MapPatch patch, @Nullable List<MapIcon> icons) {
        InventoryAccess.getPlayerUtils().sendMapUpdate(this.getViewer(), this.mapId, (byte)0, false, patch, icons);
    }

    @Override
    public void resetMap() {
        this.mapId = -MathUtils.RANDOM.nextInt(Integer.MAX_VALUE);
        ItemStack map = new ItemStack(Material.FILLED_MAP);
        MapMeta mapMeta = (MapMeta)map.getItemMeta();
        mapMeta.setMapId(this.mapId);
        map.setItemMeta((ItemMeta)mapMeta);
        this.getGui().setItem(0, new SimpleItem(new ItemWrapper(map)));
    }

    @Override
    protected void openInventory(@NotNull Player viewer) {
        this.cartographyInventory.open();
    }

    public static final class BuilderImpl
    extends AbstractSingleWindow.AbstractBuilder<CartographyWindow, CartographyWindow.Builder.Single>
    implements CartographyWindow.Builder.Single {
        @Override
        @NotNull
        public CartographyWindow build(Player viewer) {
            if (viewer == null) {
                throw new IllegalStateException("Viewer is not defined.");
            }
            if (this.guiSupplier == null) {
                throw new IllegalStateException("Gui is not defined.");
            }
            CartographySingleWindowImpl window = new CartographySingleWindowImpl(viewer, this.title, (AbstractGui)this.guiSupplier.get(), this.closeable);
            this.applyModifiers(window);
            return window;
        }
    }
}

