/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.invui.window;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.inventoryaccess.InventoryAccess;
import xyz.xenondevs.inventoryaccess.abstraction.inventory.CartographyInventory;
import xyz.xenondevs.inventoryaccess.component.ComponentWrapper;
import xyz.xenondevs.inventoryaccess.map.MapIcon;
import xyz.xenondevs.inventoryaccess.map.MapPatch;
import xyz.xenondevs.invui.gui.AbstractGui;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.item.impl.SimpleItem;
import xyz.xenondevs.invui.util.MathUtils;
import xyz.xenondevs.invui.window.AbstractSplitWindow;
import xyz.xenondevs.invui.window.CartographyWindow;

final class CartographySplitWindowImpl
extends AbstractSplitWindow
implements CartographyWindow {
    private final CartographyInventory cartographyInventory;
    private int mapId;

    public CartographySplitWindowImpl(@NotNull Player player, @Nullable ComponentWrapper title, @NotNull AbstractGui upperGui, @NotNull AbstractGui lowerGui, boolean closeable) {
        super(player, title, CartographySplitWindowImpl.createWrappingGui(upperGui), lowerGui, null, closeable);
        this.cartographyInventory = InventoryAccess.createCartographyInventory(player, title != null ? title.localized(player) : null);
        this.upperInventory = this.cartographyInventory.getBukkitInventory();
        this.resetMap();
    }

    private static AbstractGui createWrappingGui(Gui upperGui) {
        if (upperGui.getWidth() != 2 || upperGui.getHeight() != 1) {
            throw new IllegalArgumentException("Gui has to be 2x1");
        }
        Gui wrapperGui = Gui.empty(3, 1);
        wrapperGui.fillRectangle(1, 0, upperGui, true);
        return (AbstractGui)wrapperGui;
    }

    @Override
    public void updateMap(@Nullable MapPatch patch, @Nullable List<MapIcon> icons) {
        InventoryAccess.getPlayerUtils().sendMapUpdate(this.getViewer(), this.mapId, (byte)0, false, patch, icons);
    }

    @Override
    public void resetMap() {
        this.mapId = -MathUtils.RANDOM.nextInt(Integer.MAX_VALUE);
        ItemStack map = new ItemStack(Material.FILLED_MAP);
        MapMeta mapMeta = (MapMeta)map.getItemMeta();
        mapMeta.setMapId(this.mapId);
        map.setItemMeta((ItemMeta)mapMeta);
        this.getGuis()[0].setItem(0, new SimpleItem(map));
    }

    @Override
    protected void openInventory(@NotNull Player viewer) {
        this.cartographyInventory.open();
    }

    public static final class BuilderImpl
    extends AbstractSplitWindow.AbstractBuilder<CartographyWindow, CartographyWindow.Builder.Split>
    implements CartographyWindow.Builder.Split {
        @Override
        @NotNull
        public CartographyWindow build(Player viewer) {
            if (viewer == null) {
                throw new IllegalStateException("Viewer is not defined.");
            }
            if (this.upperGuiSupplier == null) {
                throw new IllegalStateException("Upper Gui is not defined.");
            }
            CartographySplitWindowImpl window = new CartographySplitWindowImpl(viewer, this.title, (AbstractGui)this.upperGuiSupplier.get(), (AbstractGui)this.lowerGuiSupplier.get(), this.closeable);
            this.applyModifiers(window);
            return window;
        }
    }
}

