/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators;

import com.xiaoxianben.watergenerators.config.ConfigLoader;
import com.xiaoxianben.watergenerators.gui.GUIHandler;
import com.xiaoxianben.watergenerators.init.ModOre;
import com.xiaoxianben.watergenerators.init.ModRecipes;
import com.xiaoxianben.watergenerators.init.modRegister.EnumModRegister;
import com.xiaoxianben.watergenerators.proxy.CommonProxy;
import com.xiaoxianben.watergenerators.tabs.ItemTab;
import com.xiaoxianben.watergenerators.tabs.MachineTab;
import com.xiaoxianben.watergenerators.tabs.MaterialTab;
import com.xiaoxianben.watergenerators.tileEntity.generator.TEGeneratorCreate;
import com.xiaoxianben.watergenerators.tileEntity.generator.TEGeneratorFluid;
import com.xiaoxianben.watergenerators.tileEntity.generator.TEGeneratorSteam;
import com.xiaoxianben.watergenerators.tileEntity.generator.TEGeneratorTurbine;
import com.xiaoxianben.watergenerators.tileEntity.generator.TEGeneratorWater;
import com.xiaoxianben.watergenerators.tileEntity.generator.TEGeneratorWaterCompressed;
import com.xiaoxianben.watergenerators.tileEntity.machine.TEMachineConcentration;
import com.xiaoxianben.watergenerators.tileEntity.machine.TEMachineVaporization;
import java.util.Arrays;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="watergenerators", name="Water Generators", version="1.6.1", dependencies="after:jei;after:enderio;after:enderioendergy;after:thermalfoundation;after:thermaldynamics;after:mekanism", useMetadata=true, acceptedMinecraftVersions="[1.12.2]")
public class WaterGenerators {
    public static final String MOD_ID = "watergenerators";
    public static final String NAME = "Water Generators";
    @Mod.Instance
    public static WaterGenerators instance;
    @SidedProxy(clientSide="com.xiaoxianben.watergenerators.proxy.ClientProxy", serverSide="com.xiaoxianben.watergenerators.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs Item_TAB;
    public static CreativeTabs MACHINE_TAB;
    public static CreativeTabs MATERIAL_TAB;

    public WaterGenerators() {
        FluidRegistry.enableUniversalBucket();
        ModRecipes.instance = new ModRecipes();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigLoader.preInitConfigLoader(event);
        Arrays.stream(EnumModRegister.values()).forEach(EnumModRegister::enable);
        for (EnumModRegister register : EnumModRegister.values()) {
            register.preInit();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerTileEntity();
        new ModOre().init();
        for (EnumModRegister register : EnumModRegister.values()) {
            register.init();
        }
        ModRecipes.instance.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GUIHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (EnumModRegister register : EnumModRegister.values()) {
            register.posInit();
        }
        ModRecipes.instance = null;
    }

    public void registerTileEntity() {
        GameRegistry.registerTileEntity(TEGeneratorTurbine.class, (ResourceLocation)new ResourceLocation(MOD_ID, "TETurbineGenerator"));
        GameRegistry.registerTileEntity(TEGeneratorFluid.class, (ResourceLocation)new ResourceLocation(MOD_ID, "TEFluidGenerator"));
        GameRegistry.registerTileEntity(TEGeneratorWater.class, (ResourceLocation)new ResourceLocation(MOD_ID, "TEWaterGenerator"));
        GameRegistry.registerTileEntity(TEGeneratorWaterCompressed.class, (ResourceLocation)new ResourceLocation(MOD_ID, "TEWaterCompressedGenerator"));
        GameRegistry.registerTileEntity(TEGeneratorSteam.class, (ResourceLocation)new ResourceLocation(MOD_ID, "TESteamGenerator"));
        GameRegistry.registerTileEntity(TEGeneratorCreate.class, (ResourceLocation)new ResourceLocation(MOD_ID, "TECreateGenerator"));
        GameRegistry.registerTileEntity(TEMachineVaporization.class, (ResourceLocation)new ResourceLocation(MOD_ID, "TEMachineVaporization"));
        GameRegistry.registerTileEntity(TEMachineConcentration.class, (ResourceLocation)new ResourceLocation(MOD_ID, "TEMachineConcentration"));
    }

    static {
        Item_TAB = new ItemTab();
        MACHINE_TAB = new MachineTab();
        MATERIAL_TAB = new MaterialTab();
    }
}

