/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.blocks;

import com.xiaoxianben.watergenerators.WaterGenerators;
import com.xiaoxianben.watergenerators.api.IHasItemNBT;
import com.xiaoxianben.watergenerators.api.IHasModel;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockBase
extends Block
implements IHasModel {
    public BlockBase(String name, Material materialIn, CreativeTabs tab, @Nullable SoundType soundType) {
        super(materialIn);
        this.func_149663_c("watergenerators-" + name);
        this.setRegistryName("watergenerators", name);
        this.func_149647_a(tab);
        this.func_149672_a(soundType == null ? SoundType.field_185852_e : soundType);
        this.func_149711_c(8.0f);
        this.setHarvestLevel("pickaxe", 1);
    }

    @ParametersAreNonnullByDefault
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (I18n.func_188566_a((String)(this.func_149739_a() + ".tooltip"))) {
            tooltip.addAll(Arrays.stream(I18n.func_135052_a((String)(this.func_149739_a() + ".tooltip"), (Object[])new Object[0]).split("\n")).collect(Collectors.toList()));
        }
    }

    @Nonnull
    @Deprecated
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180657_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity te, @Nonnull ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    @ParametersAreNonnullByDefault
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tileEntity instanceof IHasItemNBT && tagCompound != null && tagCompound.func_74764_b("itemNBT")) {
            ((IHasItemNBT)tileEntity).readItemNbt(tagCompound.func_74775_l("itemNBT"));
        }
    }

    @ParametersAreNonnullByDefault
    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        TileEntity tileEntity = world.func_175625_s(pos);
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        ItemStack itemStack = new ItemStack(this.func_180660_a(state, rand, fortune), 1, 0);
        if (tileEntity instanceof IHasItemNBT) {
            NBTTagCompound NBT = new NBTTagCompound();
            NBT.func_74782_a("itemNBT", (NBTBase)((IHasItemNBT)tileEntity).getItemNbt());
            itemStack.func_77982_d(NBT);
        }
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            for (int i = 0; i < ((IItemHandler)Objects.requireNonNull(tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null))).getSlots(); ++i) {
                ItemStack itemStack1 = ((IItemHandler)Objects.requireNonNull(tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null))).getStackInSlot(i);
                drops.add((Object)itemStack1);
            }
        }
        drops.add((Object)itemStack);
    }

    @Override
    public void registerModels() {
        WaterGenerators.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }
}

