/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.blocks.generator;

import com.xiaoxianben.watergenerators.WaterGenerators;
import com.xiaoxianben.watergenerators.blocks.generator.BlockGeneratorBasic;
import com.xiaoxianben.watergenerators.config.ConfigValue;
import com.xiaoxianben.watergenerators.init.modRegister.MinecraftRegister;
import com.xiaoxianben.watergenerators.items.component.ItemComponent;
import com.xiaoxianben.watergenerators.tileEntity.generator.TEGeneratorFluid;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockGeneratorFluid
extends BlockGeneratorBasic {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockGeneratorFluid(float level, String levelName) {
        super("fluid_generator", levelName, level, (long)((float)ConfigValue.energyBasic * level * 2.0f));
    }

    public BlockGeneratorFluid(String type, String levelName, float level) {
        super(type, levelName, level, (long)((float)ConfigValue.energyBasic * level * 4.0f));
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    @ParametersAreNonnullByDefault
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()));
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    @Override
    @ParametersAreNonnullByDefault
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ)) {
            TileEntity tileEntity = Objects.requireNonNull(worldIn.func_175625_s(pos));
            boolean isFillFluid = FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)((IFluidHandler)Objects.requireNonNull(tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing))));
            Item handItem = playerIn.func_184586_b(hand).func_77973_b();
            if (!isFillFluid && handItem != MinecraftRegister.information_finder && !(handItem instanceof ItemComponent)) {
                int ID = 1;
                playerIn.openGui((Object)WaterGenerators.instance, ID, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return true;
            }
            return isFillFluid;
        }
        return true;
    }

    @Override
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TEGeneratorFluid(this.basePowerGeneration);
    }
}

