/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.blocks.machine;

import com.xiaoxianben.watergenerators.WaterGenerators;
import com.xiaoxianben.watergenerators.blocks.BlockBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockMachineBase
extends BlockBase
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private final float level;
    private final String type;
    private final String levelName;

    public BlockMachineBase(String type, String levelName, float level) {
        super(type + "_" + levelName, Material.field_151573_f, WaterGenerators.MACHINE_TAB, SoundType.field_185852_e);
        this.func_149711_c(10.0f);
        this.type = type;
        this.levelName = levelName;
        this.level = level;
    }

    public float getLevel() {
        return this.level;
    }

    public String getLevelName() {
        return I18n.func_135052_a((String)("level." + this.levelName + ".name"), (Object[])new Object[0]);
    }

    @Nonnull
    public String func_149732_F() {
        return I18n.func_135052_a((String)(this.func_149739_a() + ".name"), (Object[])new Object[0]) + "-" + this.getLevelName();
    }

    @Nonnull
    public String func_149739_a() {
        return "tile.watergenerators-" + this.type;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Override
    @ParametersAreNonnullByDefault
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()));
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    @ParametersAreNonnullByDefault
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return null;
    }
}

