/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.config;

import com.xiaoxianben.watergenerators.config.ConfigValue;
import com.xiaoxianben.watergenerators.config.I18nOwn;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;

public class ConfigLoader {
    public static final String categoryGenerator = "generator";
    public static String modConfigurationDirectory;
    public static String WGConfigDirectory;
    private static Configuration config;
    private static Logger logger;

    public static void preInitConfigLoader(@Nonnull FMLPreInitializationEvent event) {
        logger = event.getModLog();
        modConfigurationDirectory = event.getModConfigurationDirectory().getAbsolutePath();
        WGConfigDirectory = modConfigurationDirectory + "/" + "watergenerators";
        config = new Configuration(new File(WGConfigDirectory + "/" + "watergenerators" + ".cfg"));
        config.load();
        ConfigLoader.load();
    }

    public static int addInt(String name, String category, int defaultValue) {
        int tempInt = config.getInt(name, category, defaultValue, 1, Integer.MAX_VALUE, I18nOwn.translateToLocal("config." + name + ".comment"));
        config.save();
        return tempInt;
    }

    public static float addFloat(String name, String category, float defaultValue) {
        return ConfigLoader.addFloat(name, category, defaultValue, I18nOwn.translateToLocal("config." + name + ".comment"));
    }

    public static float addFloat(String name, String category, float defaultValue, String common) {
        Property tempProperty = config.get(category, name, Float.toString(defaultValue), common, Property.Type.INTEGER);
        tempProperty.setMinValue(0);
        tempProperty.setMaxValue(3.4028234663852886E38);
        tempProperty.setComment(tempProperty.getComment() + " [range: 0 ~ " + Float.MAX_VALUE + ", default: " + defaultValue + "]");
        float returnLong = (float)tempProperty.getDouble();
        config.save();
        return returnLong;
    }

    public static void load() {
        logger.info("Started loading config.");
        config.setCategoryComment(categoryGenerator, I18nOwn.translateToLocal("category.generator.comment"));
        ConfigValue.basicAmountOfFluidToProduceEnergy = ConfigLoader.addInt("basicAmountOfFluidToProduceEnergy", categoryGenerator, 1000);
        ConfigValue.energyBasic = ConfigLoader.addInt("energyBasic", "general", 10);
        config.save();
        logger.info("Finished loading config.");
    }

    public static Logger logger() {
        return logger;
    }
}

