/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.enery;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorage
implements IEnergyStorage {
    protected long energy;
    protected long capacity;
    protected long maxReceive;
    protected long maxExtract;
    protected static final String[] NBT_KEYS = new String[]{"EnergyStorage", "Energy", "Capacity", "MaxReceive", "MaxExtract"};

    public EnergyStorage(long capacity, long maxReceive, long maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public EnergyStorage(long capacity, boolean canReceive, boolean canExtract) {
        this(capacity, canReceive ? Integer.MAX_VALUE : 0L, canExtract ? Integer.MAX_VALUE : 0L);
    }

    public EnergyStorage setCapacity(long capacity) {
        this.capacity = capacity;
        if (this.energy > capacity) {
            this.energy = capacity;
        }
        return this;
    }

    public EnergyStorage setEnergy(long energy) {
        this.energy = energy > this.capacity ? this.capacity : (energy < 0L ? 0L : energy);
        return this;
    }

    public int getIntForLong(long l) {
        return l >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = (int)Math.min(this.capacity - this.energy, Math.min(this.maxReceive, (long)maxReceive));
        if (!simulate) {
            this.energy += (long)energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = (int)Math.min(this.energy, Math.min(this.maxExtract, (long)maxExtract));
        if (!simulate) {
            this.energy -= (long)energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.getIntForLong(this.energy);
    }

    public int getMaxEnergyStored() {
        return this.getIntForLong(this.capacity);
    }

    public boolean canExtract() {
        return this.maxExtract > 0L;
    }

    public boolean canReceive() {
        return this.maxReceive > 0L;
    }

    public long getEnergyStoredLong() {
        return this.energy;
    }

    public long getMaxEnergyStoredLong() {
        return this.capacity;
    }

    public long modifyEnergyStored(long energy) {
        long energyR = this.energy;
        this.energy += energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0L) {
            this.energy = 0L;
        }
        return this.energy - energyR;
    }

    public EnergyStorage readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound nbt1 = nbt.func_74775_l(NBT_KEYS[0]);
        this.energy = nbt1.func_74763_f(NBT_KEYS[1]);
        this.capacity = nbt1.func_74763_f(NBT_KEYS[2]);
        this.maxReceive = nbt1.func_74763_f(NBT_KEYS[3]);
        this.maxExtract = nbt1.func_74763_f(NBT_KEYS[4]);
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.energy < 0L) {
            this.energy = 0L;
        }
        NBTTagCompound nbt1 = new NBTTagCompound();
        nbt1.func_74772_a(NBT_KEYS[1], this.energy);
        nbt1.func_74772_a(NBT_KEYS[2], this.capacity);
        nbt1.func_74772_a(NBT_KEYS[3], this.maxReceive);
        nbt1.func_74772_a(NBT_KEYS[4], this.maxExtract);
        nbt.func_74782_a(NBT_KEYS[0], (NBTBase)nbt1);
        return nbt;
    }
}

