/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoxianben.watergenerators.event.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="watergenerators", value={Side.CLIENT})
public class RenderFluid {
    @Nonnull
    public static final ResourceLocation BLOCK_TEX = TextureMap.field_110575_b;
    public static TextureMap fluidTextures = null;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Pre event) {
        fluidTextures = event.getMap();
    }

    @Nonnull
    public static TextureManager engine() {
        return Minecraft.func_71410_x().field_71446_o;
    }

    public static void bindBlockTexture() {
        RenderFluid.engine().func_110577_a(BLOCK_TEX);
    }

    @Nonnull
    public static TextureAtlasSprite getMissingSprite() {
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    @Nonnull
    public static TextureAtlasSprite getStillTexture(@Nonnull FluidStack fluidstack) {
        Fluid fluid = fluidstack.getFluid();
        if (fluid == null) {
            return RenderFluid.getMissingSprite();
        }
        return RenderFluid.getStillTexture(fluid);
    }

    @Nonnull
    public static TextureAtlasSprite getStillTexture(@Nonnull Fluid fluid) {
        ResourceLocation iconKey = fluid.getStill();
        TextureAtlasSprite textureExtry = fluidTextures.getTextureExtry(iconKey.toString());
        return textureExtry != null ? textureExtry : RenderFluid.getMissingSprite();
    }

    public static void renderGuiTank(@Nonnull FluidTank tank, double x, double y, double zLevel, double width, double height) {
        RenderFluid.renderGuiTank(tank.getFluid(), tank.getCapacity(), tank.getFluidAmount(), x, y, zLevel, width, height);
    }

    public static void renderGuiTank(@Nullable FluidStack fluid, int capacity, int amount, double x, double y, double zLevel, double width, double height) {
        if (fluid == null || fluid.getFluid() == null || amount <= 0) {
            return;
        }
        TextureAtlasSprite icon = RenderFluid.getStillTexture(fluid);
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)capacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        RenderFluid.bindBlockTexture();
        int color = fluid.getFluid().getColor(fluid);
        GlStateManager.func_179124_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        GlStateManager.func_179147_l();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                double minU = icon.func_94209_e();
                double maxU = icon.func_94212_f();
                double minV = icon.func_94206_g();
                double maxV = icon.func_94210_h();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder tes = tessellator.func_178180_c();
                tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                double v = minV + (maxV - minV) * (double)drawHeight / 16.0;
                double u = minU + (maxU - minU) * (double)drawWidth / 16.0;
                tes.func_181662_b((double)drawX, (double)(drawY + drawHeight), zLevel).func_187315_a(minU, v).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).func_187315_a(u, v).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)drawY, zLevel).func_187315_a(u, minV).func_181675_d();
                tes.func_181662_b((double)drawX, (double)drawY, zLevel).func_187315_a(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
            i += 16;
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

